@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.PrivateEndpointPropertyArgs
import com.pulumi.azurenative.automation.kotlin.inputs.PrivateEndpointPropertyArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.PrivateLinkServiceConnectionStatePropertyArgs
import com.pulumi.azurenative.automation.kotlin.inputs.PrivateLinkServiceConnectionStatePropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A private endpoint connection
 * Azure REST API version: 2020-01-13-preview. Prior API version in Azure Native 1.x: 2020-01-13-preview.
 * Other available API versions: 2023-05-15-preview.
 * ## Example Usage
 * ### Approve or reject a private endpoint connection with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.Automation.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         AutomationAccountName = "ddb1",
 *         PrivateEndpointConnectionName = "privateEndpointConnectionName",
 *         PrivateLinkServiceConnectionState = new AzureNative.Automation.Inputs.PrivateLinkServiceConnectionStatePropertyArgs
 *         {
 *             Description = "Approved by johndoe@contoso.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &automation.PrivateEndpointConnectionArgs{
 * 			AutomationAccountName:         pulumi.String("ddb1"),
 * 			PrivateEndpointConnectionName: pulumi.String("privateEndpointConnectionName"),
 * 			PrivateLinkServiceConnectionState: &automation.PrivateLinkServiceConnectionStatePropertyArgs{
 * 				Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.PrivateEndpointConnection;
 * import com.pulumi.azurenative.automation.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .automationAccountName("ddb1")
 *             .privateEndpointConnectionName("privateEndpointConnectionName")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Approved by johndoe@contoso.com"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:PrivateEndpointConnection privateEndpointConnectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property groupIds Gets the groupIds.
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property privateLinkServiceConnectionState Connection State of the Private Endpoint Connection.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class PrivateEndpointConnectionArgs(
    public val automationAccountName: Output<String>? = null,
    public val groupIds: Output<List<String>>? = null,
    public val privateEndpoint: Output<PrivateEndpointPropertyArgs>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState:
    Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.automation.PrivateEndpointConnectionArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var groupIds: Output<List<String>>? = null

    private var privateEndpoint: Output<PrivateEndpointPropertyArgs>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState:
        Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("addoqdoyodulrsxd")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets the groupIds.
     */
    @JvmName("qwtvekwgenhdupfr")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("dupprlkqlpxoghke")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values Gets the groupIds.
     */
    @JvmName("sadpptdsuiwtnjkq")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("hxtkylqovdfmcmmf")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointPropertyArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("ksktaroaruqcvwhf")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Connection State of the Private Endpoint Connection.
     */
    @JvmName("mvnykhbsbjxtyqsq")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStatePropertyArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("snibvgwhkpfankht")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("lddktaaxnlpvimpf")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets the groupIds.
     */
    @JvmName("lwmjwvydbjgrruxt")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values Gets the groupIds.
     */
    @JvmName("bqysfjstcnahdaak")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("icsgviwyiwxkwusu")
    public suspend fun privateEndpoint(`value`: PrivateEndpointPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument Private endpoint which the connection belongs to.
     */
    @JvmName("gtrqjpxyxvtjridg")
    public suspend
    fun privateEndpoint(argument: suspend PrivateEndpointPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("skqxwsplisodcuqh")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Connection State of the Private Endpoint Connection.
     */
    @JvmName("fypgkgypapbtfnmb")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStatePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Connection State of the Private Endpoint Connection.
     */
    @JvmName("lifwaltwcwruxsso")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStatePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStatePropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("rrxgdwcmhhfmhoyd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        automationAccountName = automationAccountName,
        groupIds = groupIds,
        privateEndpoint = privateEndpoint,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
