@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.Python3PackageArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the module type.
 * Azure REST API version: 2022-08-08.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a python 3 package
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var python3Package = new AzureNative.Automation.Python3Package("python3Package", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount33",
 *         ContentLink = new AzureNative.Automation.Inputs.ContentLinkArgs
 *         {
 *             ContentHash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha265",
 *                 Value = "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A",
 *             },
 *             Uri = "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip",
 *             Version = "1.0.0.0",
 *         },
 *         PackageName = "OmsCompositeResources",
 *         ResourceGroupName = "rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewPython3Package(ctx, "python3Package", &automation.Python3PackageArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			ContentLink: automation.ContentLinkResponse{
 * 				ContentHash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha265"),
 * 					Value:     pulumi.String("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A"),
 * 				},
 * 				Uri:     pulumi.String("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip"),
 * 				Version: pulumi.String("1.0.0.0"),
 * 			},
 * 			PackageName:       pulumi.String("OmsCompositeResources"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Python3Package;
 * import com.pulumi.azurenative.automation.Python3PackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var python3Package = new Python3Package("python3Package", Python3PackageArgs.builder()
 *             .automationAccountName("myAutomationAccount33")
 *             .contentLink(Map.ofEntries(
 *                 Map.entry("contentHash", Map.ofEntries(
 *                     Map.entry("algorithm", "sha265"),
 *                     Map.entry("value", "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A")
 *                 )),
 *                 Map.entry("uri", "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip"),
 *                 Map.entry("version", "1.0.0.0")
 *             ))
 *             .packageName("OmsCompositeResources")
 *             .resourceGroupName("rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Python3Package OmsCompositeResources /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/python3Packages/{packageName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property contentLink Gets or sets the module content link.
 * @property packageName The name of python package.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property tags Gets or sets the tags attached to the resource.
 */
public data class Python3PackageArgs(
    public val automationAccountName: Output<String>? = null,
    public val contentLink: Output<ContentLinkArgs>? = null,
    public val packageName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.Python3PackageArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.Python3PackageArgs =
        com.pulumi.azurenative.automation.Python3PackageArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .contentLink(contentLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [Python3PackageArgs].
 */
@PulumiTagMarker
public class Python3PackageArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var contentLink: Output<ContentLinkArgs>? = null

    private var packageName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("hqcqqnbwliirncte")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the module content link.
     */
    @JvmName("weujswexlaedhlqa")
    public suspend fun contentLink(`value`: Output<ContentLinkArgs>) {
        this.contentLink = value
    }

    /**
     * @param value The name of python package.
     */
    @JvmName("whhnkpdvehuqirjs")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("vcmcdvdxcnotxjmd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("bgvlummkgcailncl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("kysehkgmhimothst")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the module content link.
     */
    @JvmName("wnuegnkjslsxdkbl")
    public suspend fun contentLink(`value`: ContentLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentLink = mapped
    }

    /**
     * @param argument Gets or sets the module content link.
     */
    @JvmName("ccyxwptrewbqqqvu")
    public suspend fun contentLink(argument: suspend ContentLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ContentLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentLink = mapped
    }

    /**
     * @param value The name of python package.
     */
    @JvmName("sxwonhecofxxbhgq")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("fshcdggxolgadspt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("vismukekkbbtaedu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the tags attached to the resource.
     */
    @JvmName("xvbibyjbcbktsyed")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): Python3PackageArgs = Python3PackageArgs(
        automationAccountName = automationAccountName,
        contentLink = contentLink,
        packageName = packageName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
