@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.AdvancedScheduleResponse
import com.pulumi.azurenative.automation.kotlin.outputs.AdvancedScheduleResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Schedule].
 */
@PulumiTagMarker
public class ScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleArgs = ScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleArgsBuilder.() -> Unit) {
        val builder = ScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Schedule {
        val builtJavaResource = com.pulumi.azurenative.automation.Schedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schedule(builtJavaResource)
    }
}

/**
 * Definition of the schedule.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a schedule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.Automation.Schedule("schedule", new()
 *     {
 *         AdvancedSchedule = null,
 *         AutomationAccountName = "myAutomationAccount33",
 *         Description = "my description of schedule goes here",
 *         ExpiryTime = "2017-04-01T17:28:57.2494819Z",
 *         Frequency = "Hour",
 *         Interval = 1,
 *         Name = "mySchedule",
 *         ResourceGroupName = "rg",
 *         ScheduleName = "mySchedule",
 *         StartTime = "2017-03-27T17:28:57.2494819Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewSchedule(ctx, "schedule", &automation.ScheduleArgs{
 * 			AdvancedSchedule:      nil,
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			Description:           pulumi.String("my description of schedule goes here"),
 * 			ExpiryTime:            pulumi.String("2017-04-01T17:28:57.2494819Z"),
 * 			Frequency:             pulumi.String("Hour"),
 * 			Interval:              pulumi.Any(1),
 * 			Name:                  pulumi.String("mySchedule"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			ScheduleName:          pulumi.String("mySchedule"),
 * 			StartTime:             pulumi.String("2017-03-27T17:28:57.2494819Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Schedule;
 * import com.pulumi.azurenative.automation.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .advancedSchedule()
 *             .automationAccountName("myAutomationAccount33")
 *             .description("my description of schedule goes here")
 *             .expiryTime("2017-04-01T17:28:57.2494819Z")
 *             .frequency("Hour")
 *             .interval(1)
 *             .name("mySchedule")
 *             .resourceGroupName("rg")
 *             .scheduleName("mySchedule")
 *             .startTime("2017-03-27T17:28:57.2494819Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Schedule mySchedule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/schedules/{scheduleName}
 * ```
 */
public class Schedule internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.Schedule,
) : KotlinCustomResource(javaResource, ScheduleMapper) {
    /**
     * Gets or sets the advanced schedule.
     */
    public val advancedSchedule: Output<AdvancedScheduleResponse>?
        get() = javaResource.advancedSchedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets the creation time.
     */
    public val creationTime: Output<String>?
        get() = javaResource.creationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the end time of the schedule.
     */
    public val expiryTime: Output<String>?
        get() = javaResource.expiryTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the expiry time's offset in minutes.
     */
    public val expiryTimeOffsetMinutes: Output<Double>?
        get() = javaResource.expiryTimeOffsetMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the frequency of the schedule.
     */
    public val frequency: Output<String>?
        get() = javaResource.frequency().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the interval of the schedule.
     */
    public val interval: Output<Any>?
        get() = javaResource.interval().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets a value indicating whether this schedule is enabled.
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the last modified time.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the next run time of the schedule.
     */
    public val nextRun: Output<String>?
        get() = javaResource.nextRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the next run time's offset in minutes.
     */
    public val nextRunOffsetMinutes: Output<Double>?
        get() = javaResource.nextRunOffsetMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the start time of the schedule.
     */
    public val startTime: Output<String>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the start time's offset in minutes.
     */
    public val startTimeOffsetMinutes: Output<Double>
        get() = javaResource.startTimeOffsetMinutes().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the time zone of the schedule.
     */
    public val timeZone: Output<String>?
        get() = javaResource.timeZone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScheduleMapper : ResourceMapper<Schedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.Schedule::class == javaResource::class

    override fun map(javaResource: Resource): Schedule = Schedule(
        javaResource as
            com.pulumi.azurenative.automation.Schedule,
    )
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schedule].
 */
public suspend fun schedule(name: String, block: suspend ScheduleResourceBuilder.() -> Unit):
    Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedule(name: String): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
