@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.ScheduleArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.ScheduleFrequency
import com.pulumi.azurenative.automation.kotlin.inputs.AdvancedScheduleArgs
import com.pulumi.azurenative.automation.kotlin.inputs.AdvancedScheduleArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of the schedule.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a schedule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.Automation.Schedule("schedule", new()
 *     {
 *         AdvancedSchedule = null,
 *         AutomationAccountName = "myAutomationAccount33",
 *         Description = "my description of schedule goes here",
 *         ExpiryTime = "2017-04-01T17:28:57.2494819Z",
 *         Frequency = "Hour",
 *         Interval = 1,
 *         Name = "mySchedule",
 *         ResourceGroupName = "rg",
 *         ScheduleName = "mySchedule",
 *         StartTime = "2017-03-27T17:28:57.2494819Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewSchedule(ctx, "schedule", &automation.ScheduleArgs{
 * 			AdvancedSchedule:      nil,
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			Description:           pulumi.String("my description of schedule goes here"),
 * 			ExpiryTime:            pulumi.String("2017-04-01T17:28:57.2494819Z"),
 * 			Frequency:             pulumi.String("Hour"),
 * 			Interval:              pulumi.Any(1),
 * 			Name:                  pulumi.String("mySchedule"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			ScheduleName:          pulumi.String("mySchedule"),
 * 			StartTime:             pulumi.String("2017-03-27T17:28:57.2494819Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Schedule;
 * import com.pulumi.azurenative.automation.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .advancedSchedule()
 *             .automationAccountName("myAutomationAccount33")
 *             .description("my description of schedule goes here")
 *             .expiryTime("2017-04-01T17:28:57.2494819Z")
 *             .frequency("Hour")
 *             .interval(1)
 *             .name("mySchedule")
 *             .resourceGroupName("rg")
 *             .scheduleName("mySchedule")
 *             .startTime("2017-03-27T17:28:57.2494819Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Schedule mySchedule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/schedules/{scheduleName}
 * ```
 * @property advancedSchedule Gets or sets the AdvancedSchedule.
 * @property automationAccountName The name of the automation account.
 * @property description Gets or sets the description of the schedule.
 * @property expiryTime Gets or sets the end time of the schedule.
 * @property frequency Gets or sets the frequency of the schedule.
 * @property interval Gets or sets the interval of the schedule.
 * @property name Gets or sets the name of the Schedule.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property scheduleName The schedule name.
 * @property startTime Gets or sets the start time of the schedule.
 * @property timeZone Gets or sets the time zone of the schedule.
 */
public data class ScheduleArgs(
    public val advancedSchedule: Output<AdvancedScheduleArgs>? = null,
    public val automationAccountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val expiryTime: Output<String>? = null,
    public val frequency: Output<Either<String, ScheduleFrequency>>? = null,
    public val interval: Output<Any>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scheduleName: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.ScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.ScheduleArgs =
        com.pulumi.azurenative.automation.ScheduleArgs.builder()
            .advancedSchedule(advancedSchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .expiryTime(expiryTime?.applyValue({ args0 -> args0 }))
            .frequency(
                frequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .interval(interval?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scheduleName(scheduleName?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var advancedSchedule: Output<AdvancedScheduleArgs>? = null

    private var automationAccountName: Output<String>? = null

    private var description: Output<String>? = null

    private var expiryTime: Output<String>? = null

    private var frequency: Output<Either<String, ScheduleFrequency>>? = null

    private var interval: Output<Any>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scheduleName: Output<String>? = null

    private var startTime: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Gets or sets the AdvancedSchedule.
     */
    @JvmName("fbskgwudfcoeswnv")
    public suspend fun advancedSchedule(`value`: Output<AdvancedScheduleArgs>) {
        this.advancedSchedule = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("ekxoxicoydoikgxo")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the description of the schedule.
     */
    @JvmName("cuhdijycleopghaa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the end time of the schedule.
     */
    @JvmName("cteuqijthqxonotb")
    public suspend fun expiryTime(`value`: Output<String>) {
        this.expiryTime = value
    }

    /**
     * @param value Gets or sets the frequency of the schedule.
     */
    @JvmName("jnbpcgnrrfixcmei")
    public suspend fun frequency(`value`: Output<Either<String, ScheduleFrequency>>) {
        this.frequency = value
    }

    /**
     * @param value Gets or sets the interval of the schedule.
     */
    @JvmName("gupidnowoowmjqrs")
    public suspend fun interval(`value`: Output<Any>) {
        this.interval = value
    }

    /**
     * @param value Gets or sets the name of the Schedule.
     */
    @JvmName("xcqmybrosibchcir")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("ocrknrvrjfherxjy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The schedule name.
     */
    @JvmName("ujkkwphcwvybcclr")
    public suspend fun scheduleName(`value`: Output<String>) {
        this.scheduleName = value
    }

    /**
     * @param value Gets or sets the start time of the schedule.
     */
    @JvmName("oqbapanxhiavmcmx")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Gets or sets the time zone of the schedule.
     */
    @JvmName("jprqkrfercqsbscd")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Gets or sets the AdvancedSchedule.
     */
    @JvmName("jvmaipxhndldcknd")
    public suspend fun advancedSchedule(`value`: AdvancedScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedSchedule = mapped
    }

    /**
     * @param argument Gets or sets the AdvancedSchedule.
     */
    @JvmName("sifwkkybydbvdwwo")
    public suspend fun advancedSchedule(argument: suspend AdvancedScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = AdvancedScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.advancedSchedule = mapped
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("tqaqmbqjdmevuebo")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the description of the schedule.
     */
    @JvmName("tqaytnecjuqjbifd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the end time of the schedule.
     */
    @JvmName("cdsofttevsfludcx")
    public suspend fun expiryTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiryTime = mapped
    }

    /**
     * @param value Gets or sets the frequency of the schedule.
     */
    @JvmName("cmmrhwmyrcecrcbq")
    public suspend fun frequency(`value`: Either<String, ScheduleFrequency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Gets or sets the frequency of the schedule.
     */
    @JvmName("lgkwwucjuklerssq")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Gets or sets the frequency of the schedule.
     */
    @JvmName("hhcsosbexacvnwau")
    public fun frequency(`value`: ScheduleFrequency) {
        val toBeMapped = Either.ofRight<String, ScheduleFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Gets or sets the interval of the schedule.
     */
    @JvmName("ndntlndacsgwbvjy")
    public suspend fun interval(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Gets or sets the name of the Schedule.
     */
    @JvmName("fnddupufgjmkccww")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("wbpajkrkcufxjqen")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The schedule name.
     */
    @JvmName("fvrdgfcquopevboa")
    public suspend fun scheduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleName = mapped
    }

    /**
     * @param value Gets or sets the start time of the schedule.
     */
    @JvmName("qdjmjcwanfaxhjhb")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Gets or sets the time zone of the schedule.
     */
    @JvmName("xejksccqanggdxdx")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        advancedSchedule = advancedSchedule,
        automationAccountName = automationAccountName,
        description = description,
        expiryTime = expiryTime,
        frequency = frequency,
        interval = interval,
        name = name,
        resourceGroupName = resourceGroupName,
        scheduleName = scheduleName,
        startTime = startTime,
        timeZone = timeZone,
    )
}
