@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.VariableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of the variable.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a variable
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var variable = new AzureNative.Automation.Variable("variable", new()
 *     {
 *         AutomationAccountName = "sampleAccount9",
 *         Description = "my description",
 *         IsEncrypted = false,
 *         Name = "sampleVariable",
 *         ResourceGroupName = "rg",
 *         Value = "\"ComputerName.domain.com\"",
 *         VariableName = "sampleVariable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewVariable(ctx, "variable", &automation.VariableArgs{
 * 			AutomationAccountName: pulumi.String("sampleAccount9"),
 * 			Description:           pulumi.String("my description"),
 * 			IsEncrypted:           pulumi.Bool(false),
 * 			Name:                  pulumi.String("sampleVariable"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			Value:                 pulumi.String("\"ComputerName.domain.com\""),
 * 			VariableName:          pulumi.String("sampleVariable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Variable;
 * import com.pulumi.azurenative.automation.VariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var variable = new Variable("variable", VariableArgs.builder()
 *             .automationAccountName("sampleAccount9")
 *             .description("my description")
 *             .isEncrypted(false)
 *             .name("sampleVariable")
 *             .resourceGroupName("rg")
 *             .value("\"ComputerName.domain.com\"")
 *             .variableName("sampleVariable")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Variable sampleVariable /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/variables/{variableName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property description Gets or sets the description of the variable.
 * @property isEncrypted Gets or sets the encrypted flag of the variable.
 * @property name Gets or sets the name of the variable.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property value Gets or sets the value of the variable.
 * @property variableName The variable name.
 */
public data class VariableArgs(
    public val automationAccountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val isEncrypted: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val variableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.VariableArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.VariableArgs =
        com.pulumi.azurenative.automation.VariableArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isEncrypted(isEncrypted?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .variableName(variableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VariableArgs].
 */
@PulumiTagMarker
public class VariableArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var description: Output<String>? = null

    private var isEncrypted: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var `value`: Output<String>? = null

    private var variableName: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("lygeigbixeioapqg")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the description of the variable.
     */
    @JvmName("vabhfgfoqqhyfgrq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the encrypted flag of the variable.
     */
    @JvmName("jsedyqwqmetkhfsg")
    public suspend fun isEncrypted(`value`: Output<Boolean>) {
        this.isEncrypted = value
    }

    /**
     * @param value Gets or sets the name of the variable.
     */
    @JvmName("frykvduwagmpjqgo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("utpqregnqexcfxwo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the value of the variable.
     */
    @JvmName("pnjjrskitlclbsey")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The variable name.
     */
    @JvmName("hviayikddihitvsa")
    public suspend fun variableName(`value`: Output<String>) {
        this.variableName = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("aryauhxvxdbywhlm")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the description of the variable.
     */
    @JvmName("jcuuwdowxveullxt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the encrypted flag of the variable.
     */
    @JvmName("lpkcbotcmiiwcejp")
    public suspend fun isEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEncrypted = mapped
    }

    /**
     * @param value Gets or sets the name of the variable.
     */
    @JvmName("fnduawiyumtpjity")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("ywpdmuncloagqccr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the value of the variable.
     */
    @JvmName("caybksyrufkhcpln")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value The variable name.
     */
    @JvmName("susilmiycrgmxvxi")
    public suspend fun variableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    internal fun build(): VariableArgs = VariableArgs(
        automationAccountName = automationAccountName,
        description = description,
        isEncrypted = isEncrypted,
        name = name,
        resourceGroupName = resourceGroupName,
        `value` = `value`,
        variableName = variableName,
    )
}
