@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Watcher].
 */
@PulumiTagMarker
public class WatcherResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WatcherArgs = WatcherArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WatcherArgsBuilder.() -> Unit) {
        val builder = WatcherArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Watcher {
        val builtJavaResource = com.pulumi.azurenative.automation.Watcher(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Watcher(builtJavaResource)
    }
}

/**
 * Definition of the watcher type.
 * Azure REST API version: 2020-01-13-preview. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview.
 * ## Example Usage
 * ### Create or update watcher
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var watcher = new AzureNative.Automation.Watcher("watcher", new()
 *     {
 *         AutomationAccountName = "MyTestAutomationAccount",
 *         Description = "This is a test watcher.",
 *         ExecutionFrequencyInSeconds = 60,
 *         ResourceGroupName = "rg",
 *         ScriptName = "MyTestWatcherRunbook",
 *         ScriptRunOn = "MyTestHybridWorkerGroup",
 *         Tags = null,
 *         WatcherName = "MyTestWatcher",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewWatcher(ctx, "watcher", &automation.WatcherArgs{
 * 			AutomationAccountName:       pulumi.String("MyTestAutomationAccount"),
 * 			Description:                 pulumi.String("This is a test watcher."),
 * 			ExecutionFrequencyInSeconds: pulumi.Float64(60),
 * 			ResourceGroupName:           pulumi.String("rg"),
 * 			ScriptName:                  pulumi.String("MyTestWatcherRunbook"),
 * 			ScriptRunOn:                 pulumi.String("MyTestHybridWorkerGroup"),
 * 			Tags:                        nil,
 * 			WatcherName:                 pulumi.String("MyTestWatcher"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Watcher;
 * import com.pulumi.azurenative.automation.WatcherArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var watcher = new Watcher("watcher", WatcherArgs.builder()
 *             .automationAccountName("MyTestAutomationAccount")
 *             .description("This is a test watcher.")
 *             .executionFrequencyInSeconds(60)
 *             .resourceGroupName("rg")
 *             .scriptName("MyTestWatcherRunbook")
 *             .scriptRunOn("MyTestHybridWorkerGroup")
 *             .tags()
 *             .watcherName("MyTestWatcher")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Watcher MyTestWatcher /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/watchers/{watcherName}
 * ```
 */
public class Watcher internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.Watcher,
) : KotlinCustomResource(javaResource, WatcherMapper) {
    /**
     * Gets or sets the creation time.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the etag of the resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the frequency at which the watcher is invoked.
     */
    public val executionFrequencyInSeconds: Output<Double>?
        get() = javaResource.executionFrequencyInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Details of the user who last modified the watcher.
     */
    public val lastModifiedBy: Output<String>
        get() = javaResource.lastModifiedBy().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the last modified time.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
     */
    public val scriptName: Output<String>?
        get() = javaResource.scriptName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the parameters of the script.
     */
    public val scriptParameters: Output<Map<String, String>>?
        get() = javaResource.scriptParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the name of the hybrid worker group the watcher will run on.
     */
    public val scriptRunOn: Output<String>?
        get() = javaResource.scriptRunOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the current status of the watcher.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WatcherMapper : ResourceMapper<Watcher> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.Watcher::class == javaResource::class

    override fun map(javaResource: Resource): Watcher = Watcher(
        javaResource as
            com.pulumi.azurenative.automation.Watcher,
    )
}

/**
 * @see [Watcher].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Watcher].
 */
public suspend fun watcher(name: String, block: suspend WatcherResourceBuilder.() -> Unit):
    Watcher {
    val builder = WatcherResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Watcher].
 * @param name The _unique_ name of the resulting resource.
 */
public fun watcher(name: String): Watcher {
    val builder = WatcherResourceBuilder()
    builder.name(name)
    return builder.build()
}
