@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Update classification included in the software update configuration. A comma separated string with required values
 */
public enum class WindowsUpdateClasses(
    public val javaValue: com.pulumi.azurenative.automation.enums.WindowsUpdateClasses,
) : ConvertibleToJava<com.pulumi.azurenative.automation.enums.WindowsUpdateClasses> {
    Unclassified(com.pulumi.azurenative.automation.enums.WindowsUpdateClasses.Unclassified),
    Critical(com.pulumi.azurenative.automation.enums.WindowsUpdateClasses.Critical),
    Security(com.pulumi.azurenative.automation.enums.WindowsUpdateClasses.Security),
    UpdateRollup(com.pulumi.azurenative.automation.enums.WindowsUpdateClasses.UpdateRollup),
    FeaturePack(com.pulumi.azurenative.automation.enums.WindowsUpdateClasses.FeaturePack),
    ServicePack(com.pulumi.azurenative.automation.enums.WindowsUpdateClasses.ServicePack),
    Definition(com.pulumi.azurenative.automation.enums.WindowsUpdateClasses.Definition),
    Tools(com.pulumi.azurenative.automation.enums.WindowsUpdateClasses.Tools),
    Updates(com.pulumi.azurenative.automation.enums.WindowsUpdateClasses.Updates),
    ;

    override fun toJava(): com.pulumi.azurenative.automation.enums.WindowsUpdateClasses = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.enums.WindowsUpdateClasses):
            WindowsUpdateClasses = WindowsUpdateClasses.values().first { it.javaValue == javaType }
    }
}
