@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.AzureQueryPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure query for the update configuration.
 * @property locations List of locations to scope the query to.
 * @property scope List of Subscription or Resource Group ARM Ids.
 * @property tagSettings Tag settings for the VM.
 */
public data class AzureQueryPropertiesArgs(
    public val locations: Output<List<String>>? = null,
    public val scope: Output<List<String>>? = null,
    public val tagSettings: Output<TagSettingsPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.AzureQueryPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.AzureQueryPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.AzureQueryPropertiesArgs.builder()
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .scope(scope?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tagSettings(tagSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AzureQueryPropertiesArgs].
 */
@PulumiTagMarker
public class AzureQueryPropertiesArgsBuilder internal constructor() {
    private var locations: Output<List<String>>? = null

    private var scope: Output<List<String>>? = null

    private var tagSettings: Output<TagSettingsPropertiesArgs>? = null

    /**
     * @param value List of locations to scope the query to.
     */
    @JvmName("lhrnspwotbflyyoy")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("byjpmmtffdespqfr")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values List of locations to scope the query to.
     */
    @JvmName("oihhaioivsnewruo")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value List of Subscription or Resource Group ARM Ids.
     */
    @JvmName("xdbptgcbevnjcwxv")
    public suspend fun scope(`value`: Output<List<String>>) {
        this.scope = value
    }

    @JvmName("pstevbhfdhdlpnsv")
    public suspend fun scope(vararg values: Output<String>) {
        this.scope = Output.all(values.asList())
    }

    /**
     * @param values List of Subscription or Resource Group ARM Ids.
     */
    @JvmName("iewgdeclspoxuayk")
    public suspend fun scope(values: List<Output<String>>) {
        this.scope = Output.all(values)
    }

    /**
     * @param value Tag settings for the VM.
     */
    @JvmName("shbkjaufcjlmrkvs")
    public suspend fun tagSettings(`value`: Output<TagSettingsPropertiesArgs>) {
        this.tagSettings = value
    }

    /**
     * @param value List of locations to scope the query to.
     */
    @JvmName("rrvlehmeeihouwaq")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values List of locations to scope the query to.
     */
    @JvmName("ahtjiwuymsrgbtjw")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value List of Subscription or Resource Group ARM Ids.
     */
    @JvmName("vxpbrdhfwuyfmphx")
    public suspend fun scope(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param values List of Subscription or Resource Group ARM Ids.
     */
    @JvmName("kjspauyfpmmegqcy")
    public suspend fun scope(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Tag settings for the VM.
     */
    @JvmName("lvkpqeexyawxlweg")
    public suspend fun tagSettings(`value`: TagSettingsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagSettings = mapped
    }

    /**
     * @param argument Tag settings for the VM.
     */
    @JvmName("rnhgneaixhipsvwd")
    public suspend fun tagSettings(argument: suspend TagSettingsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TagSettingsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tagSettings = mapped
    }

    internal fun build(): AzureQueryPropertiesArgs = AzureQueryPropertiesArgs(
        locations = locations,
        scope = scope,
        tagSettings = tagSettings,
    )
}
