@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.ContentHashArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of the runbook property type.
 * @property algorithm Gets or sets the content hash algorithm used to hash the content.
 * @property value Gets or sets expected hash value of the content.
 */
public data class ContentHashArgs(
    public val algorithm: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.ContentHashArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.ContentHashArgs =
        com.pulumi.azurenative.automation.inputs.ContentHashArgs.builder()
            .algorithm(algorithm.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentHashArgs].
 */
@PulumiTagMarker
public class ContentHashArgsBuilder internal constructor() {
    private var algorithm: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Gets or sets the content hash algorithm used to hash the content.
     */
    @JvmName("xcqmjqdmljxqkvsp")
    public suspend fun algorithm(`value`: Output<String>) {
        this.algorithm = value
    }

    /**
     * @param value Gets or sets expected hash value of the content.
     */
    @JvmName("xxurttgtvgjonxyj")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Gets or sets the content hash algorithm used to hash the content.
     */
    @JvmName("nbtiwvkicdhbvgoy")
    public suspend fun algorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value Gets or sets expected hash value of the content.
     */
    @JvmName("tusrhngfbyfvwxha")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ContentHashArgs = ContentHashArgs(
        algorithm = algorithm ?: throw PulumiNullFieldException("algorithm"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
