@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetSoftwareUpdateConfigurationByNamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property softwareUpdateConfigurationName The name of the software update configuration to be created.
 */
public data class GetSoftwareUpdateConfigurationByNamePlainArgs(
    public val automationAccountName: String,
    public val resourceGroupName: String,
    public val softwareUpdateConfigurationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetSoftwareUpdateConfigurationByNamePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.automation.inputs.GetSoftwareUpdateConfigurationByNamePlainArgs =
        com.pulumi.azurenative.automation.inputs.GetSoftwareUpdateConfigurationByNamePlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .softwareUpdateConfigurationName(softwareUpdateConfigurationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSoftwareUpdateConfigurationByNamePlainArgs].
 */
@PulumiTagMarker
public class GetSoftwareUpdateConfigurationByNamePlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var softwareUpdateConfigurationName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("ihrdvmxmldukvhwh")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("qqmqlbnalirvabph")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the software update configuration to be created.
     */
    @JvmName("quuywkqkpkjyjvde")
    public suspend fun softwareUpdateConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.softwareUpdateConfigurationName = mapped
    }

    internal fun build(): GetSoftwareUpdateConfigurationByNamePlainArgs =
        GetSoftwareUpdateConfigurationByNamePlainArgs(
            automationAccountName = automationAccountName ?: throw
                PulumiNullFieldException("automationAccountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            softwareUpdateConfigurationName = softwareUpdateConfigurationName ?: throw
                PulumiNullFieldException("softwareUpdateConfigurationName"),
        )
}
