@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetVariablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property variableName The name of variable.
 */
public data class GetVariablePlainArgs(
    public val automationAccountName: String,
    public val resourceGroupName: String,
    public val variableName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetVariablePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetVariablePlainArgs =
        com.pulumi.azurenative.automation.inputs.GetVariablePlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .variableName(variableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVariablePlainArgs].
 */
@PulumiTagMarker
public class GetVariablePlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var variableName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("idlndoouhgycnfvf")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("vunengtayuyedaof")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of variable.
     */
    @JvmName("nddgmfhvxraslyqk")
    public suspend fun variableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.variableName = mapped
    }

    internal fun build(): GetVariablePlainArgs = GetVariablePlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        variableName = variableName ?: throw PulumiNullFieldException("variableName"),
    )
}
