@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.LinuxPropertiesArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.LinuxUpdateClasses
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Linux specific update configuration.
 * @property excludedPackageNameMasks packages excluded from the software update configuration.
 * @property includedPackageClassifications Update classifications included in the software update configuration.
 * @property includedPackageNameMasks packages included from the software update configuration.
 * @property rebootSetting Reboot setting for the software update configuration.
 */
public data class LinuxPropertiesArgs(
    public val excludedPackageNameMasks: Output<List<String>>? = null,
    public val includedPackageClassifications: Output<Either<String, LinuxUpdateClasses>>? = null,
    public val includedPackageNameMasks: Output<List<String>>? = null,
    public val rebootSetting: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.LinuxPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.LinuxPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.LinuxPropertiesArgs.builder()
            .excludedPackageNameMasks(
                excludedPackageNameMasks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .includedPackageClassifications(
                includedPackageClassifications?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .includedPackageNameMasks(
                includedPackageNameMasks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .rebootSetting(rebootSetting?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinuxPropertiesArgs].
 */
@PulumiTagMarker
public class LinuxPropertiesArgsBuilder internal constructor() {
    private var excludedPackageNameMasks: Output<List<String>>? = null

    private var includedPackageClassifications: Output<Either<String, LinuxUpdateClasses>>? = null

    private var includedPackageNameMasks: Output<List<String>>? = null

    private var rebootSetting: Output<String>? = null

    /**
     * @param value packages excluded from the software update configuration.
     */
    @JvmName("qgdxgdghltmqacur")
    public suspend fun excludedPackageNameMasks(`value`: Output<List<String>>) {
        this.excludedPackageNameMasks = value
    }

    @JvmName("muhwgurvldhhhugj")
    public suspend fun excludedPackageNameMasks(vararg values: Output<String>) {
        this.excludedPackageNameMasks = Output.all(values.asList())
    }

    /**
     * @param values packages excluded from the software update configuration.
     */
    @JvmName("mlkvclwrjllsponv")
    public suspend fun excludedPackageNameMasks(values: List<Output<String>>) {
        this.excludedPackageNameMasks = Output.all(values)
    }

    /**
     * @param value Update classifications included in the software update configuration.
     */
    @JvmName("dqyjeqsclyopalrj")
    public suspend
    fun includedPackageClassifications(`value`: Output<Either<String, LinuxUpdateClasses>>) {
        this.includedPackageClassifications = value
    }

    /**
     * @param value packages included from the software update configuration.
     */
    @JvmName("axidlfgnvwqxrkkv")
    public suspend fun includedPackageNameMasks(`value`: Output<List<String>>) {
        this.includedPackageNameMasks = value
    }

    @JvmName("sugdfpibjbknhkcf")
    public suspend fun includedPackageNameMasks(vararg values: Output<String>) {
        this.includedPackageNameMasks = Output.all(values.asList())
    }

    /**
     * @param values packages included from the software update configuration.
     */
    @JvmName("uvbwoqtwcfvvyqyj")
    public suspend fun includedPackageNameMasks(values: List<Output<String>>) {
        this.includedPackageNameMasks = Output.all(values)
    }

    /**
     * @param value Reboot setting for the software update configuration.
     */
    @JvmName("uyslhwmyyrhtkeja")
    public suspend fun rebootSetting(`value`: Output<String>) {
        this.rebootSetting = value
    }

    /**
     * @param value packages excluded from the software update configuration.
     */
    @JvmName("gythwhshglwrugpc")
    public suspend fun excludedPackageNameMasks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedPackageNameMasks = mapped
    }

    /**
     * @param values packages excluded from the software update configuration.
     */
    @JvmName("mvxtgxleynonibql")
    public suspend fun excludedPackageNameMasks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedPackageNameMasks = mapped
    }

    /**
     * @param value Update classifications included in the software update configuration.
     */
    @JvmName("xpyolfjrryvjjcbu")
    public suspend fun includedPackageClassifications(`value`: Either<String, LinuxUpdateClasses>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedPackageClassifications = mapped
    }

    /**
     * @param value Update classifications included in the software update configuration.
     */
    @JvmName("wjejbmmnlsbcxapc")
    public fun includedPackageClassifications(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LinuxUpdateClasses>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedPackageClassifications = mapped
    }

    /**
     * @param value Update classifications included in the software update configuration.
     */
    @JvmName("nynfumehjoepyald")
    public fun includedPackageClassifications(`value`: LinuxUpdateClasses) {
        val toBeMapped = Either.ofRight<String, LinuxUpdateClasses>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedPackageClassifications = mapped
    }

    /**
     * @param value packages included from the software update configuration.
     */
    @JvmName("sqmtbldmvmcajpym")
    public suspend fun includedPackageNameMasks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedPackageNameMasks = mapped
    }

    /**
     * @param values packages included from the software update configuration.
     */
    @JvmName("dytfmtifxyweelpe")
    public suspend fun includedPackageNameMasks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedPackageNameMasks = mapped
    }

    /**
     * @param value Reboot setting for the software update configuration.
     */
    @JvmName("grrldvobjrfrtcww")
    public suspend fun rebootSetting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    internal fun build(): LinuxPropertiesArgs = LinuxPropertiesArgs(
        excludedPackageNameMasks = excludedPackageNameMasks,
        includedPackageClassifications = includedPackageClassifications,
        includedPackageNameMasks = includedPackageNameMasks,
        rebootSetting = rebootSetting,
    )
}
