@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.NonAzureQueryPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Non Azure query for the update configuration.
 * @property functionAlias Log Analytics Saved Search name.
 * @property workspaceId Workspace Id for Log Analytics in which the saved Search is resided.
 */
public data class NonAzureQueryPropertiesArgs(
    public val functionAlias: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.NonAzureQueryPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.NonAzureQueryPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.NonAzureQueryPropertiesArgs.builder()
            .functionAlias(functionAlias?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NonAzureQueryPropertiesArgs].
 */
@PulumiTagMarker
public class NonAzureQueryPropertiesArgsBuilder internal constructor() {
    private var functionAlias: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Log Analytics Saved Search name.
     */
    @JvmName("napqdiapbpaeyfnq")
    public suspend fun functionAlias(`value`: Output<String>) {
        this.functionAlias = value
    }

    /**
     * @param value Workspace Id for Log Analytics in which the saved Search is resided.
     */
    @JvmName("srtwhmsrtyauvsfx")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Log Analytics Saved Search name.
     */
    @JvmName("gdohchxecpgolwct")
    public suspend fun functionAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAlias = mapped
    }

    /**
     * @param value Workspace Id for Log Analytics in which the saved Search is resided.
     */
    @JvmName("hijurvyvlhvxgaet")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): NonAzureQueryPropertiesArgs = NonAzureQueryPropertiesArgs(
        functionAlias = functionAlias,
        workspaceId = workspaceId,
    )
}
