@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.RunAsCredentialAssociationPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of RunAs credential to use for hybrid worker.
 * @property name Gets or sets the name of the credential.
 */
public data class RunAsCredentialAssociationPropertyArgs(
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.automation.inputs.RunAsCredentialAssociationPropertyArgs> {
    override fun toJava():
        com.pulumi.azurenative.automation.inputs.RunAsCredentialAssociationPropertyArgs =
        com.pulumi.azurenative.automation.inputs.RunAsCredentialAssociationPropertyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RunAsCredentialAssociationPropertyArgs].
 */
@PulumiTagMarker
public class RunAsCredentialAssociationPropertyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Gets or sets the name of the credential.
     */
    @JvmName("hhqyyyshaemygdso")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the name of the credential.
     */
    @JvmName("rwanxnufkdlddypf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RunAsCredentialAssociationPropertyArgs =
        RunAsCredentialAssociationPropertyArgs(
            name = name,
        )
}
