@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.RunbookParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of the runbook parameter type.
 * @property defaultValue Gets or sets the default value of parameter.
 * @property isMandatory Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
 * @property position Get or sets the position of the parameter.
 * @property type Gets or sets the type of the parameter.
 */
public data class RunbookParameterArgs(
    public val defaultValue: Output<String>? = null,
    public val isMandatory: Output<Boolean>? = null,
    public val position: Output<Int>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.RunbookParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.RunbookParameterArgs =
        com.pulumi.azurenative.automation.inputs.RunbookParameterArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .isMandatory(isMandatory?.applyValue({ args0 -> args0 }))
            .position(position?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RunbookParameterArgs].
 */
@PulumiTagMarker
public class RunbookParameterArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var isMandatory: Output<Boolean>? = null

    private var position: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value Gets or sets the default value of parameter.
     */
    @JvmName("haalxigsufeexgtp")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
     */
    @JvmName("glekgvfbvtrebyfd")
    public suspend fun isMandatory(`value`: Output<Boolean>) {
        this.isMandatory = value
    }

    /**
     * @param value Get or sets the position of the parameter.
     */
    @JvmName("poxyolslpjhntecj")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value Gets or sets the type of the parameter.
     */
    @JvmName("ddaxwlxmocnsqltd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the default value of parameter.
     */
    @JvmName("mhvtkpyslvlhrxal")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
     */
    @JvmName("dkyhloictesudqej")
    public suspend fun isMandatory(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isMandatory = mapped
    }

    /**
     * @param value Get or sets the position of the parameter.
     */
    @JvmName("ovjxgwlkvnxretww")
    public suspend fun position(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value Gets or sets the type of the parameter.
     */
    @JvmName("ryyxwhngrsvrngri")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RunbookParameterArgs = RunbookParameterArgs(
        defaultValue = defaultValue,
        isMandatory = isMandatory,
        position = position,
        type = type,
    )
}
