@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.WindowsPropertiesArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.WindowsUpdateClasses
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Windows specific update configuration.
 * @property excludedKbNumbers KB numbers excluded from the software update configuration.
 * @property includedKbNumbers KB numbers included from the software update configuration.
 * @property includedUpdateClassifications Update classification included in the software update configuration. A comma separated string with required values
 * @property rebootSetting Reboot setting for the software update configuration.
 */
public data class WindowsPropertiesArgs(
    public val excludedKbNumbers: Output<List<String>>? = null,
    public val includedKbNumbers: Output<List<String>>? = null,
    public val includedUpdateClassifications: Output<Either<String, WindowsUpdateClasses>>? = null,
    public val rebootSetting: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.WindowsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.WindowsPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.WindowsPropertiesArgs.builder()
            .excludedKbNumbers(excludedKbNumbers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includedKbNumbers(includedKbNumbers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includedUpdateClassifications(
                includedUpdateClassifications?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rebootSetting(rebootSetting?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WindowsPropertiesArgs].
 */
@PulumiTagMarker
public class WindowsPropertiesArgsBuilder internal constructor() {
    private var excludedKbNumbers: Output<List<String>>? = null

    private var includedKbNumbers: Output<List<String>>? = null

    private var includedUpdateClassifications: Output<Either<String, WindowsUpdateClasses>>? = null

    private var rebootSetting: Output<String>? = null

    /**
     * @param value KB numbers excluded from the software update configuration.
     */
    @JvmName("mntpghumcoagknbj")
    public suspend fun excludedKbNumbers(`value`: Output<List<String>>) {
        this.excludedKbNumbers = value
    }

    @JvmName("gxekjrabpwoapviv")
    public suspend fun excludedKbNumbers(vararg values: Output<String>) {
        this.excludedKbNumbers = Output.all(values.asList())
    }

    /**
     * @param values KB numbers excluded from the software update configuration.
     */
    @JvmName("aqqaxutfkyetyjsy")
    public suspend fun excludedKbNumbers(values: List<Output<String>>) {
        this.excludedKbNumbers = Output.all(values)
    }

    /**
     * @param value KB numbers included from the software update configuration.
     */
    @JvmName("ptyyerhtebhafxvx")
    public suspend fun includedKbNumbers(`value`: Output<List<String>>) {
        this.includedKbNumbers = value
    }

    @JvmName("efpcbbdcyjwiyodr")
    public suspend fun includedKbNumbers(vararg values: Output<String>) {
        this.includedKbNumbers = Output.all(values.asList())
    }

    /**
     * @param values KB numbers included from the software update configuration.
     */
    @JvmName("olkxgkogeqpbweqy")
    public suspend fun includedKbNumbers(values: List<Output<String>>) {
        this.includedKbNumbers = Output.all(values)
    }

    /**
     * @param value Update classification included in the software update configuration. A comma separated string with required values
     */
    @JvmName("kgosbtmghyakxcov")
    public suspend
    fun includedUpdateClassifications(`value`: Output<Either<String, WindowsUpdateClasses>>) {
        this.includedUpdateClassifications = value
    }

    /**
     * @param value Reboot setting for the software update configuration.
     */
    @JvmName("wptllhibmnpgmkef")
    public suspend fun rebootSetting(`value`: Output<String>) {
        this.rebootSetting = value
    }

    /**
     * @param value KB numbers excluded from the software update configuration.
     */
    @JvmName("acgqxgkgwpnmbwpf")
    public suspend fun excludedKbNumbers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedKbNumbers = mapped
    }

    /**
     * @param values KB numbers excluded from the software update configuration.
     */
    @JvmName("tafnhqoqqgcjfcjo")
    public suspend fun excludedKbNumbers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedKbNumbers = mapped
    }

    /**
     * @param value KB numbers included from the software update configuration.
     */
    @JvmName("huwbwgmehgkqkckf")
    public suspend fun includedKbNumbers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedKbNumbers = mapped
    }

    /**
     * @param values KB numbers included from the software update configuration.
     */
    @JvmName("vmttknddaulrpciw")
    public suspend fun includedKbNumbers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedKbNumbers = mapped
    }

    /**
     * @param value Update classification included in the software update configuration. A comma separated string with required values
     */
    @JvmName("wxjnrsjcyfnkhdmw")
    public suspend fun includedUpdateClassifications(`value`: Either<String, WindowsUpdateClasses>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedUpdateClassifications = mapped
    }

    /**
     * @param value Update classification included in the software update configuration. A comma separated string with required values
     */
    @JvmName("smvltqoawvdpjldk")
    public fun includedUpdateClassifications(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WindowsUpdateClasses>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedUpdateClassifications = mapped
    }

    /**
     * @param value Update classification included in the software update configuration. A comma separated string with required values
     */
    @JvmName("ypnwbodbbcxqhkln")
    public fun includedUpdateClassifications(`value`: WindowsUpdateClasses) {
        val toBeMapped = Either.ofRight<String, WindowsUpdateClasses>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedUpdateClassifications = mapped
    }

    /**
     * @param value Reboot setting for the software update configuration.
     */
    @JvmName("smiokpgoecyssyrf")
    public suspend fun rebootSetting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    internal fun build(): WindowsPropertiesArgs = WindowsPropertiesArgs(
        excludedKbNumbers = excludedKbNumbers,
        includedKbNumbers = includedKbNumbers,
        includedUpdateClassifications = includedUpdateClassifications,
        rebootSetting = rebootSetting,
    )
}
