@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The properties of the create advanced schedule monthly occurrence.
 * @property day Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
 * @property occurrence Occurrence of the week within the month. Must be between 1 and 5
 */
public data class AdvancedScheduleMonthlyOccurrenceResponse(
    public val day: String? = null,
    public val occurrence: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.AdvancedScheduleMonthlyOccurrenceResponse):
            AdvancedScheduleMonthlyOccurrenceResponse = AdvancedScheduleMonthlyOccurrenceResponse(
            day = javaType.day().map({ args0 -> args0 }).orElse(null),
            occurrence = javaType.occurrence().map({ args0 -> args0 }).orElse(null),
        )
    }
}
