@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of hybrid runbook worker group.
 * @property credential Sets the credential of a worker group.
 * @property groupType Type of the HybridWorkerGroup.
 * @property id Fully qualified resource Id for the resource
 * @property name The name of the resource
 * @property systemData Resource system metadata.
 * @property type The type of the resource.
 */
public data class GetHybridRunbookWorkerGroupResult(
    public val credential: RunAsCredentialAssociationPropertyResponse? = null,
    public val groupType: String? = null,
    public val id: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetHybridRunbookWorkerGroupResult):
            GetHybridRunbookWorkerGroupResult = GetHybridRunbookWorkerGroupResult(
            credential = javaType.credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.RunAsCredentialAssociationPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            groupType = javaType.groupType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
