@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the Runtime Environment type.
 * @property defaultPackages List of Default packages for Environment
 * @property description Gets or sets the description.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property language Language of Runtime Environment
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Version of Language
 */
public data class GetRuntimeEnvironmentResult(
    public val defaultPackages: Map<String, String>? = null,
    public val description: String? = null,
    public val id: String,
    public val language: String? = null,
    public val location: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetRuntimeEnvironmentResult):
            GetRuntimeEnvironmentResult = GetRuntimeEnvironmentResult(
            defaultPackages = javaType.defaultPackages().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            language = javaType.language().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
