@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin

import com.pulumi.azurenative.autonomousdevelopmentplatform.DataPoolArgs.builder
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs.DataPoolLocationArgs
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs.DataPoolLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ADP Data Pool
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * ## Example Usage
 * ### Put Data Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataPool = new AzureNative.AutonomousDevelopmentPlatform.DataPool("dataPool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DataPoolName = "sampledp",
 *         Locations = new[]
 *         {
 *             new AzureNative.AutonomousDevelopmentPlatform.Inputs.DataPoolLocationArgs
 *             {
 *                 Encryption = new AzureNative.AutonomousDevelopmentPlatform.Inputs.DataPoolEncryptionArgs
 *                 {
 *                     KeyName = "key1",
 *                     KeyVaultUri = "https://vaulturi",
 *                     KeyVersion = "123",
 *                     UserAssignedIdentity = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1",
 *                 },
 *                 Name = "westus",
 *             },
 *         },
 *         ResourceGroupName = "adpClient",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/autonomousdevelopmentplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := autonomousdevelopmentplatform.NewDataPool(ctx, "dataPool", &autonomousdevelopmentplatform.DataPoolArgs{
 * 			AccountName:  pulumi.String("sampleacct"),
 * 			DataPoolName: pulumi.String("sampledp"),
 * 			Locations: []autonomousdevelopmentplatform.DataPoolLocationArgs{
 * 				{
 * 					Encryption: {
 * 						KeyName:              pulumi.String("key1"),
 * 						KeyVaultUri:          pulumi.String("https://vaulturi"),
 * 						KeyVersion:           pulumi.String("123"),
 * 						UserAssignedIdentity: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1"),
 * 					},
 * 					Name: pulumi.String("westus"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("adpClient"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.autonomousdevelopmentplatform.DataPool;
 * import com.pulumi.azurenative.autonomousdevelopmentplatform.DataPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataPool = new DataPool("dataPool", DataPoolArgs.builder()
 *             .accountName("sampleacct")
 *             .dataPoolName("sampledp")
 *             .locations(Map.ofEntries(
 *                 Map.entry("encryption", Map.ofEntries(
 *                     Map.entry("keyName", "key1"),
 *                     Map.entry("keyVaultUri", "https://vaulturi"),
 *                     Map.entry("keyVersion", "123"),
 *                     Map.entry("userAssignedIdentity", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1")
 *                 )),
 *                 Map.entry("name", "westus")
 *             ))
 *             .resourceGroupName("adpClient")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:autonomousdevelopmentplatform:DataPool dp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AutonomousDevelopmentPlatform/accounts/{accountName}/dataPools/{dataPoolName}
 * ```
 * @property accountName The name of the ADP account
 * @property dataPoolName The name of the Data Pool
 * @property locations Gets or sets the collection of locations where Data Pool resources should be created
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags
 */
public data class DataPoolArgs(
    public val accountName: Output<String>? = null,
    public val dataPoolName: Output<String>? = null,
    public val locations: Output<List<DataPoolLocationArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.autonomousdevelopmentplatform.DataPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.autonomousdevelopmentplatform.DataPoolArgs =
        com.pulumi.azurenative.autonomousdevelopmentplatform.DataPoolArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dataPoolName(dataPoolName?.applyValue({ args0 -> args0 }))
            .locations(
                locations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataPoolArgs].
 */
@PulumiTagMarker
public class DataPoolArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dataPoolName: Output<String>? = null

    private var locations: Output<List<DataPoolLocationArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the ADP account
     */
    @JvmName("qkjnabhdfrghsdng")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the Data Pool
     */
    @JvmName("cmjksefilxmmgxut")
    public suspend fun dataPoolName(`value`: Output<String>) {
        this.dataPoolName = value
    }

    /**
     * @param value Gets or sets the collection of locations where Data Pool resources should be created
     */
    @JvmName("nobfxcunsgmephlb")
    public suspend fun locations(`value`: Output<List<DataPoolLocationArgs>>) {
        this.locations = value
    }

    @JvmName("jbkbevjhfnsmngjo")
    public suspend fun locations(vararg values: Output<DataPoolLocationArgs>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the collection of locations where Data Pool resources should be created
     */
    @JvmName("wvjnvwistxqdnkea")
    public suspend fun locations(values: List<Output<DataPoolLocationArgs>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mgabaluhyntknvrs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qigruyniaragxgkv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the ADP account
     */
    @JvmName("iicvfyyubgxioppp")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Data Pool
     */
    @JvmName("timbrspgimnqrqid")
    public suspend fun dataPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPoolName = mapped
    }

    /**
     * @param value Gets or sets the collection of locations where Data Pool resources should be created
     */
    @JvmName("amuqfbrrfbbnpjtk")
    public suspend fun locations(`value`: List<DataPoolLocationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param argument Gets or sets the collection of locations where Data Pool resources should be created
     */
    @JvmName("ylioytgewjryjxfw")
    public suspend fun locations(argument: List<suspend DataPoolLocationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataPoolLocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param argument Gets or sets the collection of locations where Data Pool resources should be created
     */
    @JvmName("bpaustwpbyrlxivd")
    public suspend fun locations(vararg argument: suspend DataPoolLocationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataPoolLocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param argument Gets or sets the collection of locations where Data Pool resources should be created
     */
    @JvmName("bibeoddjtrmfnaur")
    public suspend fun locations(argument: suspend DataPoolLocationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataPoolLocationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param values Gets or sets the collection of locations where Data Pool resources should be created
     */
    @JvmName("eosplhkdrpoayfuc")
    public suspend fun locations(vararg values: DataPoolLocationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ixvdvimpkydwjfqm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("fvxmlunfhvntevgt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("bxppucqomwjdolrf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataPoolArgs = DataPoolArgs(
        accountName = accountName,
        dataPoolName = dataPoolName,
        locations = locations,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
