@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.AvsFunctions.getAddonPlain
import com.pulumi.azurenative.avs.AvsFunctions.getAuthorizationPlain
import com.pulumi.azurenative.avs.AvsFunctions.getCloudLinkPlain
import com.pulumi.azurenative.avs.AvsFunctions.getClusterPlain
import com.pulumi.azurenative.avs.AvsFunctions.getDatastorePlain
import com.pulumi.azurenative.avs.AvsFunctions.getGlobalReachConnectionPlain
import com.pulumi.azurenative.avs.AvsFunctions.getHcxEnterpriseSitePlain
import com.pulumi.azurenative.avs.AvsFunctions.getPlacementPolicyPlain
import com.pulumi.azurenative.avs.AvsFunctions.getPrivateCloudPlain
import com.pulumi.azurenative.avs.AvsFunctions.getScriptExecutionLogsPlain
import com.pulumi.azurenative.avs.AvsFunctions.getScriptExecutionPlain
import com.pulumi.azurenative.avs.AvsFunctions.getWorkloadNetworkDhcpPlain
import com.pulumi.azurenative.avs.AvsFunctions.getWorkloadNetworkDnsServicePlain
import com.pulumi.azurenative.avs.AvsFunctions.getWorkloadNetworkDnsZonePlain
import com.pulumi.azurenative.avs.AvsFunctions.getWorkloadNetworkPortMirroringPlain
import com.pulumi.azurenative.avs.AvsFunctions.getWorkloadNetworkPublicIPPlain
import com.pulumi.azurenative.avs.AvsFunctions.getWorkloadNetworkSegmentPlain
import com.pulumi.azurenative.avs.AvsFunctions.getWorkloadNetworkVMGroupPlain
import com.pulumi.azurenative.avs.AvsFunctions.listClusterZonesPlain
import com.pulumi.azurenative.avs.AvsFunctions.listPrivateCloudAdminCredentialsPlain
import com.pulumi.azurenative.avs.kotlin.inputs.GetAddonPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetAddonPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetAuthorizationPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetAuthorizationPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetCloudLinkPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetCloudLinkPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetDatastorePlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetDatastorePlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetGlobalReachConnectionPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetGlobalReachConnectionPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetHcxEnterpriseSitePlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetHcxEnterpriseSitePlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetPlacementPolicyPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetPlacementPolicyPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetPrivateCloudPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetPrivateCloudPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetScriptExecutionLogsPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetScriptExecutionLogsPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetScriptExecutionPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetScriptExecutionPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkDhcpPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkDhcpPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkDnsServicePlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkDnsServicePlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkDnsZonePlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkDnsZonePlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkPortMirroringPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkPortMirroringPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkPublicIPPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkPublicIPPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkSegmentPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkSegmentPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkVMGroupPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.GetWorkloadNetworkVMGroupPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.ListClusterZonesPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.ListClusterZonesPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.ListPrivateCloudAdminCredentialsPlainArgs
import com.pulumi.azurenative.avs.kotlin.inputs.ListPrivateCloudAdminCredentialsPlainArgsBuilder
import com.pulumi.azurenative.avs.kotlin.outputs.GetAddonResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetAuthorizationResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetCloudLinkResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetClusterResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetDatastoreResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetGlobalReachConnectionResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetHcxEnterpriseSiteResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetPlacementPolicyResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetPrivateCloudResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetScriptExecutionLogsResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetScriptExecutionResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkDhcpResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkDnsServiceResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkDnsZoneResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkPortMirroringResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkPublicIPResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkSegmentResult
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkVMGroupResult
import com.pulumi.azurenative.avs.kotlin.outputs.ListClusterZonesResult
import com.pulumi.azurenative.avs.kotlin.outputs.ListPrivateCloudAdminCredentialsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.avs.kotlin.outputs.GetAddonResult.Companion.toKotlin as getAddonResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetAuthorizationResult.Companion.toKotlin as getAuthorizationResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetCloudLinkResult.Companion.toKotlin as getCloudLinkResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetDatastoreResult.Companion.toKotlin as getDatastoreResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetGlobalReachConnectionResult.Companion.toKotlin as getGlobalReachConnectionResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetHcxEnterpriseSiteResult.Companion.toKotlin as getHcxEnterpriseSiteResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetPlacementPolicyResult.Companion.toKotlin as getPlacementPolicyResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetPrivateCloudResult.Companion.toKotlin as getPrivateCloudResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetScriptExecutionLogsResult.Companion.toKotlin as getScriptExecutionLogsResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetScriptExecutionResult.Companion.toKotlin as getScriptExecutionResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkDhcpResult.Companion.toKotlin as getWorkloadNetworkDhcpResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkDnsServiceResult.Companion.toKotlin as getWorkloadNetworkDnsServiceResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkDnsZoneResult.Companion.toKotlin as getWorkloadNetworkDnsZoneResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkPortMirroringResult.Companion.toKotlin as getWorkloadNetworkPortMirroringResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkPublicIPResult.Companion.toKotlin as getWorkloadNetworkPublicIPResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkSegmentResult.Companion.toKotlin as getWorkloadNetworkSegmentResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.GetWorkloadNetworkVMGroupResult.Companion.toKotlin as getWorkloadNetworkVMGroupResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.ListClusterZonesResult.Companion.toKotlin as listClusterZonesResultToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.ListPrivateCloudAdminCredentialsResult.Companion.toKotlin as listPrivateCloudAdminCredentialsResultToKotlin

public object AvsFunctions {
    /**
     * An addon resource
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2021-01-01-preview, 2023-03-01.
     * @param argument null
     * @return An addon resource
     */
    public suspend fun getAddon(argument: GetAddonPlainArgs): GetAddonResult =
        getAddonResultToKotlin(getAddonPlain(argument.toJava()).await())

    /**
     * @see [getAddon].
     * @param addonName Name of the addon for the private cloud
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An addon resource
     */
    public suspend fun getAddon(
        addonName: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetAddonResult {
        val argument = GetAddonPlainArgs(
            addonName = addonName,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getAddonResultToKotlin(getAddonPlain(argument.toJava()).await())
    }

    /**
     * @see [getAddon].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetAddonPlainArgs].
     * @return An addon resource
     */
    public suspend fun getAddon(argument: suspend GetAddonPlainArgsBuilder.() -> Unit):
        GetAddonResult {
        val builder = GetAddonPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAddonResultToKotlin(getAddonPlain(builtArgument.toJava()).await())
    }

    /**
     * ExpressRoute Circuit Authorization
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return ExpressRoute Circuit Authorization
     */
    public suspend fun getAuthorization(argument: GetAuthorizationPlainArgs): GetAuthorizationResult =
        getAuthorizationResultToKotlin(getAuthorizationPlain(argument.toJava()).await())

    /**
     * @see [getAuthorization].
     * @param authorizationName Name of the ExpressRoute Circuit Authorization in the private cloud
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return ExpressRoute Circuit Authorization
     */
    public suspend fun getAuthorization(
        authorizationName: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetAuthorizationResult {
        val argument = GetAuthorizationPlainArgs(
            authorizationName = authorizationName,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getAuthorizationResultToKotlin(getAuthorizationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorization].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetAuthorizationPlainArgs].
     * @return ExpressRoute Circuit Authorization
     */
    public suspend
    fun getAuthorization(argument: suspend GetAuthorizationPlainArgsBuilder.() -> Unit):
        GetAuthorizationResult {
        val builder = GetAuthorizationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizationResultToKotlin(getAuthorizationPlain(builtArgument.toJava()).await())
    }

    /**
     * A cloud link resource
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return A cloud link resource
     */
    public suspend fun getCloudLink(argument: GetCloudLinkPlainArgs): GetCloudLinkResult =
        getCloudLinkResultToKotlin(getCloudLinkPlain(argument.toJava()).await())

    /**
     * @see [getCloudLink].
     * @param cloudLinkName Name of the cloud link resource
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A cloud link resource
     */
    public suspend fun getCloudLink(
        cloudLinkName: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetCloudLinkResult {
        val argument = GetCloudLinkPlainArgs(
            cloudLinkName = cloudLinkName,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getCloudLinkResultToKotlin(getCloudLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetCloudLinkPlainArgs].
     * @return A cloud link resource
     */
    public suspend fun getCloudLink(argument: suspend GetCloudLinkPlainArgsBuilder.() -> Unit):
        GetCloudLinkResult {
        val builder = GetCloudLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudLinkResultToKotlin(getCloudLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * A cluster resource
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2020-03-20, 2021-06-01, 2023-03-01.
     * @param argument null
     * @return A cluster resource
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName Name of the cluster in the private cloud
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A cluster resource
     */
    public suspend fun getCluster(
        clusterName: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A cluster resource
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * A datastore resource
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return A datastore resource
     */
    public suspend fun getDatastore(argument: GetDatastorePlainArgs): GetDatastoreResult =
        getDatastoreResultToKotlin(getDatastorePlain(argument.toJava()).await())

    /**
     * @see [getDatastore].
     * @param clusterName Name of the cluster in the private cloud
     * @param datastoreName Name of the datastore in the private cloud cluster
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A datastore resource
     */
    public suspend fun getDatastore(
        clusterName: String,
        datastoreName: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetDatastoreResult {
        val argument = GetDatastorePlainArgs(
            clusterName = clusterName,
            datastoreName = datastoreName,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getDatastoreResultToKotlin(getDatastorePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatastore].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetDatastorePlainArgs].
     * @return A datastore resource
     */
    public suspend fun getDatastore(argument: suspend GetDatastorePlainArgsBuilder.() -> Unit):
        GetDatastoreResult {
        val builder = GetDatastorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatastoreResultToKotlin(getDatastorePlain(builtArgument.toJava()).await())
    }

    /**
     * A global reach connection resource
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return A global reach connection resource
     */
    public suspend fun getGlobalReachConnection(argument: GetGlobalReachConnectionPlainArgs):
        GetGlobalReachConnectionResult =
        getGlobalReachConnectionResultToKotlin(getGlobalReachConnectionPlain(argument.toJava()).await())

    /**
     * @see [getGlobalReachConnection].
     * @param globalReachConnectionName Name of the global reach connection in the private cloud
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A global reach connection resource
     */
    public suspend fun getGlobalReachConnection(
        globalReachConnectionName: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetGlobalReachConnectionResult {
        val argument = GetGlobalReachConnectionPlainArgs(
            globalReachConnectionName = globalReachConnectionName,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getGlobalReachConnectionResultToKotlin(getGlobalReachConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalReachConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetGlobalReachConnectionPlainArgs].
     * @return A global reach connection resource
     */
    public suspend
    fun getGlobalReachConnection(argument: suspend GetGlobalReachConnectionPlainArgsBuilder.() -> Unit):
        GetGlobalReachConnectionResult {
        val builder = GetGlobalReachConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalReachConnectionResultToKotlin(getGlobalReachConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * An HCX Enterprise Site resource
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return An HCX Enterprise Site resource
     */
    public suspend fun getHcxEnterpriseSite(argument: GetHcxEnterpriseSitePlainArgs):
        GetHcxEnterpriseSiteResult =
        getHcxEnterpriseSiteResultToKotlin(getHcxEnterpriseSitePlain(argument.toJava()).await())

    /**
     * @see [getHcxEnterpriseSite].
     * @param hcxEnterpriseSiteName Name of the HCX Enterprise Site in the private cloud
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An HCX Enterprise Site resource
     */
    public suspend fun getHcxEnterpriseSite(
        hcxEnterpriseSiteName: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetHcxEnterpriseSiteResult {
        val argument = GetHcxEnterpriseSitePlainArgs(
            hcxEnterpriseSiteName = hcxEnterpriseSiteName,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getHcxEnterpriseSiteResultToKotlin(getHcxEnterpriseSitePlain(argument.toJava()).await())
    }

    /**
     * @see [getHcxEnterpriseSite].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetHcxEnterpriseSitePlainArgs].
     * @return An HCX Enterprise Site resource
     */
    public suspend
    fun getHcxEnterpriseSite(argument: suspend GetHcxEnterpriseSitePlainArgsBuilder.() -> Unit):
        GetHcxEnterpriseSiteResult {
        val builder = GetHcxEnterpriseSitePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHcxEnterpriseSiteResultToKotlin(getHcxEnterpriseSitePlain(builtArgument.toJava()).await())
    }

    /**
     * A vSphere Distributed Resource Scheduler (DRS) placement policy
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return A vSphere Distributed Resource Scheduler (DRS) placement policy
     */
    public suspend fun getPlacementPolicy(argument: GetPlacementPolicyPlainArgs):
        GetPlacementPolicyResult =
        getPlacementPolicyResultToKotlin(getPlacementPolicyPlain(argument.toJava()).await())

    /**
     * @see [getPlacementPolicy].
     * @param clusterName Name of the cluster in the private cloud
     * @param placementPolicyName Name of the VMware vSphere Distributed Resource Scheduler (DRS) placement policy
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A vSphere Distributed Resource Scheduler (DRS) placement policy
     */
    public suspend fun getPlacementPolicy(
        clusterName: String,
        placementPolicyName: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetPlacementPolicyResult {
        val argument = GetPlacementPolicyPlainArgs(
            clusterName = clusterName,
            placementPolicyName = placementPolicyName,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getPlacementPolicyResultToKotlin(getPlacementPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPlacementPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetPlacementPolicyPlainArgs].
     * @return A vSphere Distributed Resource Scheduler (DRS) placement policy
     */
    public suspend
    fun getPlacementPolicy(argument: suspend GetPlacementPolicyPlainArgsBuilder.() -> Unit):
        GetPlacementPolicyResult {
        val builder = GetPlacementPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPlacementPolicyResultToKotlin(getPlacementPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * A private cloud resource
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return A private cloud resource
     */
    public suspend fun getPrivateCloud(argument: GetPrivateCloudPlainArgs): GetPrivateCloudResult =
        getPrivateCloudResultToKotlin(getPrivateCloudPlain(argument.toJava()).await())

    /**
     * @see [getPrivateCloud].
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A private cloud resource
     */
    public suspend fun getPrivateCloud(privateCloudName: String, resourceGroupName: String):
        GetPrivateCloudResult {
        val argument = GetPrivateCloudPlainArgs(
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateCloudResultToKotlin(getPrivateCloudPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateCloud].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetPrivateCloudPlainArgs].
     * @return A private cloud resource
     */
    public suspend fun getPrivateCloud(argument: suspend GetPrivateCloudPlainArgsBuilder.() -> Unit):
        GetPrivateCloudResult {
        val builder = GetPrivateCloudPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateCloudResultToKotlin(getPrivateCloudPlain(builtArgument.toJava()).await())
    }

    /**
     * An instance of a script executed by a user - custom or AVS
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return An instance of a script executed by a user - custom or AVS
     */
    public suspend fun getScriptExecution(argument: GetScriptExecutionPlainArgs):
        GetScriptExecutionResult =
        getScriptExecutionResultToKotlin(getScriptExecutionPlain(argument.toJava()).await())

    /**
     * @see [getScriptExecution].
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scriptExecutionName Name of the user-invoked script execution resource
     * @return An instance of a script executed by a user - custom or AVS
     */
    public suspend fun getScriptExecution(
        privateCloudName: String,
        resourceGroupName: String,
        scriptExecutionName: String,
    ): GetScriptExecutionResult {
        val argument = GetScriptExecutionPlainArgs(
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
            scriptExecutionName = scriptExecutionName,
        )
        return getScriptExecutionResultToKotlin(getScriptExecutionPlain(argument.toJava()).await())
    }

    /**
     * @see [getScriptExecution].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetScriptExecutionPlainArgs].
     * @return An instance of a script executed by a user - custom or AVS
     */
    public suspend
    fun getScriptExecution(argument: suspend GetScriptExecutionPlainArgsBuilder.() -> Unit):
        GetScriptExecutionResult {
        val builder = GetScriptExecutionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScriptExecutionResultToKotlin(getScriptExecutionPlain(builtArgument.toJava()).await())
    }

    /**
     * Return the logs for a script execution resource
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return An instance of a script executed by a user - custom or AVS
     */
    public suspend fun getScriptExecutionLogs(argument: GetScriptExecutionLogsPlainArgs):
        GetScriptExecutionLogsResult =
        getScriptExecutionLogsResultToKotlin(getScriptExecutionLogsPlain(argument.toJava()).await())

    /**
     * @see [getScriptExecutionLogs].
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scriptExecutionName Name of the user-invoked script execution resource
     * @return An instance of a script executed by a user - custom or AVS
     */
    public suspend fun getScriptExecutionLogs(
        privateCloudName: String,
        resourceGroupName: String,
        scriptExecutionName: String,
    ): GetScriptExecutionLogsResult {
        val argument = GetScriptExecutionLogsPlainArgs(
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
            scriptExecutionName = scriptExecutionName,
        )
        return getScriptExecutionLogsResultToKotlin(getScriptExecutionLogsPlain(argument.toJava()).await())
    }

    /**
     * @see [getScriptExecutionLogs].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetScriptExecutionLogsPlainArgs].
     * @return An instance of a script executed by a user - custom or AVS
     */
    public suspend
    fun getScriptExecutionLogs(argument: suspend GetScriptExecutionLogsPlainArgsBuilder.() -> Unit):
        GetScriptExecutionLogsResult {
        val builder = GetScriptExecutionLogsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScriptExecutionLogsResultToKotlin(getScriptExecutionLogsPlain(builtArgument.toJava()).await())
    }

    /**
     * NSX DHCP
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2021-01-01-preview, 2023-03-01.
     * @param argument null
     * @return NSX DHCP
     */
    public suspend fun getWorkloadNetworkDhcp(argument: GetWorkloadNetworkDhcpPlainArgs):
        GetWorkloadNetworkDhcpResult =
        getWorkloadNetworkDhcpResultToKotlin(getWorkloadNetworkDhcpPlain(argument.toJava()).await())

    /**
     * @see [getWorkloadNetworkDhcp].
     * @param dhcpId NSX DHCP identifier. Generally the same as the DHCP display name
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return NSX DHCP
     */
    public suspend fun getWorkloadNetworkDhcp(
        dhcpId: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetWorkloadNetworkDhcpResult {
        val argument = GetWorkloadNetworkDhcpPlainArgs(
            dhcpId = dhcpId,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getWorkloadNetworkDhcpResultToKotlin(getWorkloadNetworkDhcpPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadNetworkDhcp].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetWorkloadNetworkDhcpPlainArgs].
     * @return NSX DHCP
     */
    public suspend
    fun getWorkloadNetworkDhcp(argument: suspend GetWorkloadNetworkDhcpPlainArgsBuilder.() -> Unit):
        GetWorkloadNetworkDhcpResult {
        val builder = GetWorkloadNetworkDhcpPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadNetworkDhcpResultToKotlin(getWorkloadNetworkDhcpPlain(builtArgument.toJava()).await())
    }

    /**
     * NSX DNS Service
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return NSX DNS Service
     */
    public suspend fun getWorkloadNetworkDnsService(argument: GetWorkloadNetworkDnsServicePlainArgs):
        GetWorkloadNetworkDnsServiceResult =
        getWorkloadNetworkDnsServiceResultToKotlin(getWorkloadNetworkDnsServicePlain(argument.toJava()).await())

    /**
     * @see [getWorkloadNetworkDnsService].
     * @param dnsServiceId NSX DNS Service identifier. Generally the same as the DNS Service's display name
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return NSX DNS Service
     */
    public suspend fun getWorkloadNetworkDnsService(
        dnsServiceId: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetWorkloadNetworkDnsServiceResult {
        val argument = GetWorkloadNetworkDnsServicePlainArgs(
            dnsServiceId = dnsServiceId,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getWorkloadNetworkDnsServiceResultToKotlin(getWorkloadNetworkDnsServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadNetworkDnsService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetWorkloadNetworkDnsServicePlainArgs].
     * @return NSX DNS Service
     */
    public suspend
    fun getWorkloadNetworkDnsService(argument: suspend GetWorkloadNetworkDnsServicePlainArgsBuilder.() -> Unit):
        GetWorkloadNetworkDnsServiceResult {
        val builder = GetWorkloadNetworkDnsServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadNetworkDnsServiceResultToKotlin(getWorkloadNetworkDnsServicePlain(builtArgument.toJava()).await())
    }

    /**
     * NSX DNS Zone
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return NSX DNS Zone
     */
    public suspend fun getWorkloadNetworkDnsZone(argument: GetWorkloadNetworkDnsZonePlainArgs):
        GetWorkloadNetworkDnsZoneResult =
        getWorkloadNetworkDnsZoneResultToKotlin(getWorkloadNetworkDnsZonePlain(argument.toJava()).await())

    /**
     * @see [getWorkloadNetworkDnsZone].
     * @param dnsZoneId NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return NSX DNS Zone
     */
    public suspend fun getWorkloadNetworkDnsZone(
        dnsZoneId: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetWorkloadNetworkDnsZoneResult {
        val argument = GetWorkloadNetworkDnsZonePlainArgs(
            dnsZoneId = dnsZoneId,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getWorkloadNetworkDnsZoneResultToKotlin(getWorkloadNetworkDnsZonePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadNetworkDnsZone].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetWorkloadNetworkDnsZonePlainArgs].
     * @return NSX DNS Zone
     */
    public suspend
    fun getWorkloadNetworkDnsZone(argument: suspend GetWorkloadNetworkDnsZonePlainArgsBuilder.() -> Unit):
        GetWorkloadNetworkDnsZoneResult {
        val builder = GetWorkloadNetworkDnsZonePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadNetworkDnsZoneResultToKotlin(getWorkloadNetworkDnsZonePlain(builtArgument.toJava()).await())
    }

    /**
     * NSX Port Mirroring
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return NSX Port Mirroring
     */
    public suspend
    fun getWorkloadNetworkPortMirroring(argument: GetWorkloadNetworkPortMirroringPlainArgs):
        GetWorkloadNetworkPortMirroringResult =
        getWorkloadNetworkPortMirroringResultToKotlin(getWorkloadNetworkPortMirroringPlain(argument.toJava()).await())

    /**
     * @see [getWorkloadNetworkPortMirroring].
     * @param portMirroringId NSX Port Mirroring identifier. Generally the same as the Port Mirroring display name
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return NSX Port Mirroring
     */
    public suspend fun getWorkloadNetworkPortMirroring(
        portMirroringId: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): GetWorkloadNetworkPortMirroringResult {
        val argument = GetWorkloadNetworkPortMirroringPlainArgs(
            portMirroringId = portMirroringId,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return getWorkloadNetworkPortMirroringResultToKotlin(getWorkloadNetworkPortMirroringPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadNetworkPortMirroring].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetWorkloadNetworkPortMirroringPlainArgs].
     * @return NSX Port Mirroring
     */
    public suspend
    fun getWorkloadNetworkPortMirroring(argument: suspend GetWorkloadNetworkPortMirroringPlainArgsBuilder.() -> Unit):
        GetWorkloadNetworkPortMirroringResult {
        val builder = GetWorkloadNetworkPortMirroringPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadNetworkPortMirroringResultToKotlin(getWorkloadNetworkPortMirroringPlain(builtArgument.toJava()).await())
    }

    /**
     * NSX Public IP Block
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return NSX Public IP Block
     */
    public suspend fun getWorkloadNetworkPublicIP(argument: GetWorkloadNetworkPublicIPPlainArgs):
        GetWorkloadNetworkPublicIPResult =
        getWorkloadNetworkPublicIPResultToKotlin(getWorkloadNetworkPublicIPPlain(argument.toJava()).await())

    /**
     * @see [getWorkloadNetworkPublicIP].
     * @param privateCloudName Name of the private cloud
     * @param publicIPId NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return NSX Public IP Block
     */
    public suspend fun getWorkloadNetworkPublicIP(
        privateCloudName: String,
        publicIPId: String,
        resourceGroupName: String,
    ): GetWorkloadNetworkPublicIPResult {
        val argument = GetWorkloadNetworkPublicIPPlainArgs(
            privateCloudName = privateCloudName,
            publicIPId = publicIPId,
            resourceGroupName = resourceGroupName,
        )
        return getWorkloadNetworkPublicIPResultToKotlin(getWorkloadNetworkPublicIPPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadNetworkPublicIP].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetWorkloadNetworkPublicIPPlainArgs].
     * @return NSX Public IP Block
     */
    public suspend
    fun getWorkloadNetworkPublicIP(argument: suspend GetWorkloadNetworkPublicIPPlainArgsBuilder.() -> Unit):
        GetWorkloadNetworkPublicIPResult {
        val builder = GetWorkloadNetworkPublicIPPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadNetworkPublicIPResultToKotlin(getWorkloadNetworkPublicIPPlain(builtArgument.toJava()).await())
    }

    /**
     * NSX Segment
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return NSX Segment
     */
    public suspend fun getWorkloadNetworkSegment(argument: GetWorkloadNetworkSegmentPlainArgs):
        GetWorkloadNetworkSegmentResult =
        getWorkloadNetworkSegmentResultToKotlin(getWorkloadNetworkSegmentPlain(argument.toJava()).await())

    /**
     * @see [getWorkloadNetworkSegment].
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param segmentId NSX Segment identifier. Generally the same as the Segment's display name
     * @return NSX Segment
     */
    public suspend fun getWorkloadNetworkSegment(
        privateCloudName: String,
        resourceGroupName: String,
        segmentId: String,
    ): GetWorkloadNetworkSegmentResult {
        val argument = GetWorkloadNetworkSegmentPlainArgs(
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
            segmentId = segmentId,
        )
        return getWorkloadNetworkSegmentResultToKotlin(getWorkloadNetworkSegmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadNetworkSegment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetWorkloadNetworkSegmentPlainArgs].
     * @return NSX Segment
     */
    public suspend
    fun getWorkloadNetworkSegment(argument: suspend GetWorkloadNetworkSegmentPlainArgsBuilder.() -> Unit):
        GetWorkloadNetworkSegmentResult {
        val builder = GetWorkloadNetworkSegmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadNetworkSegmentResultToKotlin(getWorkloadNetworkSegmentPlain(builtArgument.toJava()).await())
    }

    /**
     * NSX VM Group
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return NSX VM Group
     */
    public suspend fun getWorkloadNetworkVMGroup(argument: GetWorkloadNetworkVMGroupPlainArgs):
        GetWorkloadNetworkVMGroupResult =
        getWorkloadNetworkVMGroupResultToKotlin(getWorkloadNetworkVMGroupPlain(argument.toJava()).await())

    /**
     * @see [getWorkloadNetworkVMGroup].
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmGroupId NSX VM Group identifier. Generally the same as the VM Group's display name
     * @return NSX VM Group
     */
    public suspend fun getWorkloadNetworkVMGroup(
        privateCloudName: String,
        resourceGroupName: String,
        vmGroupId: String,
    ): GetWorkloadNetworkVMGroupResult {
        val argument = GetWorkloadNetworkVMGroupPlainArgs(
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
            vmGroupId = vmGroupId,
        )
        return getWorkloadNetworkVMGroupResultToKotlin(getWorkloadNetworkVMGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadNetworkVMGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;GetWorkloadNetworkVMGroupPlainArgs].
     * @return NSX VM Group
     */
    public suspend
    fun getWorkloadNetworkVMGroup(argument: suspend GetWorkloadNetworkVMGroupPlainArgsBuilder.() -> Unit):
        GetWorkloadNetworkVMGroupResult {
        val builder = GetWorkloadNetworkVMGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadNetworkVMGroupResultToKotlin(getWorkloadNetworkVMGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * List of all zones and associated hosts for a cluster
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return List of all zones and associated hosts for a cluster
     */
    public suspend fun listClusterZones(argument: ListClusterZonesPlainArgs): ListClusterZonesResult =
        listClusterZonesResultToKotlin(listClusterZonesPlain(argument.toJava()).await())

    /**
     * @see [listClusterZones].
     * @param clusterName Name of the cluster in the private cloud
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return List of all zones and associated hosts for a cluster
     */
    public suspend fun listClusterZones(
        clusterName: String,
        privateCloudName: String,
        resourceGroupName: String,
    ): ListClusterZonesResult {
        val argument = ListClusterZonesPlainArgs(
            clusterName = clusterName,
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return listClusterZonesResultToKotlin(listClusterZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [listClusterZones].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;ListClusterZonesPlainArgs].
     * @return List of all zones and associated hosts for a cluster
     */
    public suspend
    fun listClusterZones(argument: suspend ListClusterZonesPlainArgsBuilder.() -> Unit):
        ListClusterZonesResult {
        val builder = ListClusterZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listClusterZonesResultToKotlin(listClusterZonesPlain(builtArgument.toJava()).await())
    }

    /**
     * Administrative credentials for accessing vCenter and NSX-T
     * Azure REST API version: 2022-05-01.
     * Other available API versions: 2023-03-01.
     * @param argument null
     * @return Administrative credentials for accessing vCenter and NSX-T
     */
    public suspend
    fun listPrivateCloudAdminCredentials(argument: ListPrivateCloudAdminCredentialsPlainArgs):
        ListPrivateCloudAdminCredentialsResult =
        listPrivateCloudAdminCredentialsResultToKotlin(listPrivateCloudAdminCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listPrivateCloudAdminCredentials].
     * @param privateCloudName Name of the private cloud
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Administrative credentials for accessing vCenter and NSX-T
     */
    public suspend fun listPrivateCloudAdminCredentials(
        privateCloudName: String,
        resourceGroupName: String,
    ): ListPrivateCloudAdminCredentialsResult {
        val argument = ListPrivateCloudAdminCredentialsPlainArgs(
            privateCloudName = privateCloudName,
            resourceGroupName = resourceGroupName,
        )
        return listPrivateCloudAdminCredentialsResultToKotlin(listPrivateCloudAdminCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listPrivateCloudAdminCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;avs&#46;kotlin&#46;inputs&#46;ListPrivateCloudAdminCredentialsPlainArgs].
     * @return Administrative credentials for accessing vCenter and NSX-T
     */
    public suspend
    fun listPrivateCloudAdminCredentials(argument: suspend ListPrivateCloudAdminCredentialsPlainArgsBuilder.() -> Unit):
        ListPrivateCloudAdminCredentialsResult {
        val builder = ListPrivateCloudAdminCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listPrivateCloudAdminCredentialsResultToKotlin(listPrivateCloudAdminCredentialsPlain(builtArgument.toJava()).await())
    }
}
