@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkloadNetworkPublicIP].
 */
@PulumiTagMarker
public class WorkloadNetworkPublicIPResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadNetworkPublicIPArgs = WorkloadNetworkPublicIPArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadNetworkPublicIPArgsBuilder.() -> Unit) {
        val builder = WorkloadNetworkPublicIPArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkloadNetworkPublicIP {
        val builtJavaResource =
            com.pulumi.azurenative.avs.WorkloadNetworkPublicIP(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkloadNetworkPublicIP(builtJavaResource)
    }
}

/**
 * NSX Public IP Block
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreatePublicIP
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkPublicIP = new AzureNative.AVS.WorkloadNetworkPublicIP("workloadNetworkPublicIP", new()
 *     {
 *         DisplayName = "publicIP1",
 *         NumberOfPublicIPs = 32,
 *         PrivateCloudName = "cloud1",
 *         PublicIPId = "publicIP1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkPublicIP(ctx, "workloadNetworkPublicIP", &avs.WorkloadNetworkPublicIPArgs{
 * 			DisplayName:       pulumi.String("publicIP1"),
 * 			NumberOfPublicIPs: pulumi.Float64(32),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			PublicIPId:        pulumi.String("publicIP1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkPublicIP;
 * import com.pulumi.azurenative.avs.WorkloadNetworkPublicIPArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkPublicIP = new WorkloadNetworkPublicIP("workloadNetworkPublicIP", WorkloadNetworkPublicIPArgs.builder()
 *             .displayName("publicIP1")
 *             .numberOfPublicIPs(32)
 *             .privateCloudName("cloud1")
 *             .publicIPId("publicIP1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkPublicIP publicIP1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/publicIPs/{publicIPId}
 * ```
 */
public class WorkloadNetworkPublicIP internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.WorkloadNetworkPublicIP,
) : KotlinCustomResource(javaResource, WorkloadNetworkPublicIPMapper) {
    /**
     * Display name of the Public IP Block.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Number of Public IPs requested.
     */
    public val numberOfPublicIPs: Output<Double>?
        get() = javaResource.numberOfPublicIPs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * CIDR Block of the Public IP Block.
     */
    public val publicIPBlock: Output<String>
        get() = javaResource.publicIPBlock().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadNetworkPublicIPMapper : ResourceMapper<WorkloadNetworkPublicIP> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.WorkloadNetworkPublicIP::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadNetworkPublicIP =
        WorkloadNetworkPublicIP(javaResource as com.pulumi.azurenative.avs.WorkloadNetworkPublicIP)
}

/**
 * @see [WorkloadNetworkPublicIP].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadNetworkPublicIP].
 */
public suspend fun workloadNetworkPublicIP(
    name: String,
    block: suspend WorkloadNetworkPublicIPResourceBuilder.() -> Unit,
): WorkloadNetworkPublicIP {
    val builder = WorkloadNetworkPublicIPResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadNetworkPublicIP].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadNetworkPublicIP(name: String): WorkloadNetworkPublicIP {
    val builder = WorkloadNetworkPublicIPResourceBuilder()
    builder.name(name)
    return builder.build()
}
