@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.AddonArcPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of an Arc addon
 * @property addonType The type of private cloud addon
 * Expected value is 'Arc'.
 * @property vCenter The VMware vCenter resource ID
 */
public data class AddonArcPropertiesArgs(
    public val addonType: Output<String>,
    public val vCenter: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.AddonArcPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.AddonArcPropertiesArgs =
        com.pulumi.azurenative.avs.inputs.AddonArcPropertiesArgs.builder()
            .addonType(addonType.applyValue({ args0 -> args0 }))
            .vCenter(vCenter?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddonArcPropertiesArgs].
 */
@PulumiTagMarker
public class AddonArcPropertiesArgsBuilder internal constructor() {
    private var addonType: Output<String>? = null

    private var vCenter: Output<String>? = null

    /**
     * @param value The type of private cloud addon
     * Expected value is 'Arc'.
     */
    @JvmName("ukirxopfexvsxegv")
    public suspend fun addonType(`value`: Output<String>) {
        this.addonType = value
    }

    /**
     * @param value The VMware vCenter resource ID
     */
    @JvmName("nywphokjyxbptykb")
    public suspend fun vCenter(`value`: Output<String>) {
        this.vCenter = value
    }

    /**
     * @param value The type of private cloud addon
     * Expected value is 'Arc'.
     */
    @JvmName("jstwuafqhumyhlgd")
    public suspend fun addonType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonType = mapped
    }

    /**
     * @param value The VMware vCenter resource ID
     */
    @JvmName("gdkfoiyiucuqnxhl")
    public suspend fun vCenter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCenter = mapped
    }

    internal fun build(): AddonArcPropertiesArgs = AddonArcPropertiesArgs(
        addonType = addonType ?: throw PulumiNullFieldException("addonType"),
        vCenter = vCenter,
    )
}
