@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.AddonVrPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of a vSphere Replication (VR) addon
 * @property addonType The type of private cloud addon
 * Expected value is 'VR'.
 * @property vrsCount The vSphere Replication Server (VRS) count
 */
public data class AddonVrPropertiesArgs(
    public val addonType: Output<String>,
    public val vrsCount: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.AddonVrPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.AddonVrPropertiesArgs =
        com.pulumi.azurenative.avs.inputs.AddonVrPropertiesArgs.builder()
            .addonType(addonType.applyValue({ args0 -> args0 }))
            .vrsCount(vrsCount.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddonVrPropertiesArgs].
 */
@PulumiTagMarker
public class AddonVrPropertiesArgsBuilder internal constructor() {
    private var addonType: Output<String>? = null

    private var vrsCount: Output<Int>? = null

    /**
     * @param value The type of private cloud addon
     * Expected value is 'VR'.
     */
    @JvmName("lfcknylmedtywtqm")
    public suspend fun addonType(`value`: Output<String>) {
        this.addonType = value
    }

    /**
     * @param value The vSphere Replication Server (VRS) count
     */
    @JvmName("nvrvqljxlcoixaqe")
    public suspend fun vrsCount(`value`: Output<Int>) {
        this.vrsCount = value
    }

    /**
     * @param value The type of private cloud addon
     * Expected value is 'VR'.
     */
    @JvmName("ynkhxgtocpvvhoxn")
    public suspend fun addonType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonType = mapped
    }

    /**
     * @param value The vSphere Replication Server (VRS) count
     */
    @JvmName("ctaesvkbnffxunou")
    public suspend fun vrsCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vrsCount = mapped
    }

    internal fun build(): AddonVrPropertiesArgs = AddonVrPropertiesArgs(
        addonType = addonType ?: throw PulumiNullFieldException("addonType"),
        vrsCount = vrsCount ?: throw PulumiNullFieldException("vrsCount"),
    )
}
