@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.DiskPoolVolumeArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.MountOptionEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An iSCSI volume from Microsoft.StoragePool provider
 * @property lunName Name of the LUN to be used for datastore
 * @property mountOption Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
 * @property targetId Azure resource ID of the iSCSI target
 */
public data class DiskPoolVolumeArgs(
    public val lunName: Output<String>,
    public val mountOption: Output<Either<String, MountOptionEnum>>? = null,
    public val targetId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.DiskPoolVolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.DiskPoolVolumeArgs =
        com.pulumi.azurenative.avs.inputs.DiskPoolVolumeArgs.builder()
            .lunName(lunName.applyValue({ args0 -> args0 }))
            .mountOption(
                mountOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetId(targetId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskPoolVolumeArgs].
 */
@PulumiTagMarker
public class DiskPoolVolumeArgsBuilder internal constructor() {
    private var lunName: Output<String>? = null

    private var mountOption: Output<Either<String, MountOptionEnum>>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value Name of the LUN to be used for datastore
     */
    @JvmName("embanaahjgpufefv")
    public suspend fun lunName(`value`: Output<String>) {
        this.lunName = value
    }

    /**
     * @param value Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
     */
    @JvmName("syryughxfeiykpjf")
    public suspend fun mountOption(`value`: Output<Either<String, MountOptionEnum>>) {
        this.mountOption = value
    }

    /**
     * @param value Azure resource ID of the iSCSI target
     */
    @JvmName("cpyxcllusxuksxem")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value Name of the LUN to be used for datastore
     */
    @JvmName("nkgqbsbwxmpcwrvd")
    public suspend fun lunName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lunName = mapped
    }

    /**
     * @param value Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
     */
    @JvmName("rivexbsgmitggbyl")
    public suspend fun mountOption(`value`: Either<String, MountOptionEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOption = mapped
    }

    /**
     * @param value Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
     */
    @JvmName("udeblhankosvucjv")
    public fun mountOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MountOptionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountOption = mapped
    }

    /**
     * @param value Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
     */
    @JvmName("ybqaxeqqfsjfersm")
    public fun mountOption(`value`: MountOptionEnum) {
        val toBeMapped = Either.ofRight<String, MountOptionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountOption = mapped
    }

    /**
     * @param value Azure resource ID of the iSCSI target
     */
    @JvmName("xtimjohniygcumdi")
    public suspend fun targetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): DiskPoolVolumeArgs = DiskPoolVolumeArgs(
        lunName = lunName ?: throw PulumiNullFieldException("lunName"),
        mountOption = mountOption,
        targetId = targetId ?: throw PulumiNullFieldException("targetId"),
    )
}
