@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetAuthorizationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationName Name of the ExpressRoute Circuit Authorization in the private cloud
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAuthorizationPlainArgs(
    public val authorizationName: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetAuthorizationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetAuthorizationPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetAuthorizationPlainArgs.builder()
            .authorizationName(authorizationName.let({ args0 -> args0 }))
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthorizationPlainArgs].
 */
@PulumiTagMarker
public class GetAuthorizationPlainArgsBuilder internal constructor() {
    private var authorizationName: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the ExpressRoute Circuit Authorization in the private cloud
     */
    @JvmName("qsgrsrbsillvsryi")
    public suspend fun authorizationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationName = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("amlgocadnhtaymdj")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cuwikatolhalobug")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAuthorizationPlainArgs = GetAuthorizationPlainArgs(
        authorizationName = authorizationName ?: throw PulumiNullFieldException("authorizationName"),
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
