@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetPlacementPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName Name of the cluster in the private cloud
 * @property placementPolicyName Name of the VMware vSphere Distributed Resource Scheduler (DRS) placement policy
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPlacementPolicyPlainArgs(
    public val clusterName: String,
    public val placementPolicyName: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetPlacementPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetPlacementPolicyPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetPlacementPolicyPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .placementPolicyName(placementPolicyName.let({ args0 -> args0 }))
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPlacementPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetPlacementPolicyPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var placementPolicyName: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the cluster in the private cloud
     */
    @JvmName("rdiuyqdgamwwlucj")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the VMware vSphere Distributed Resource Scheduler (DRS) placement policy
     */
    @JvmName("gkcemexniebtpmeu")
    public suspend fun placementPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.placementPolicyName = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("jbeyleeswrprechj")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nxygwclpmijtikvr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPlacementPolicyPlainArgs = GetPlacementPolicyPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        placementPolicyName = placementPolicyName ?: throw PulumiNullFieldException("placementPolicyName"),
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
