@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDhcpPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dhcpId NSX DHCP identifier. Generally the same as the DHCP display name
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetWorkloadNetworkDhcpPlainArgs(
    public val dhcpId: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDhcpPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDhcpPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDhcpPlainArgs.builder()
            .dhcpId(dhcpId.let({ args0 -> args0 }))
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadNetworkDhcpPlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadNetworkDhcpPlainArgsBuilder internal constructor() {
    private var dhcpId: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value NSX DHCP identifier. Generally the same as the DHCP display name
     */
    @JvmName("virkxaxsfvvfisnn")
    public suspend fun dhcpId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dhcpId = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("jxrdpoefeddjncrt")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("utbhpqysergmjggx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWorkloadNetworkDhcpPlainArgs = GetWorkloadNetworkDhcpPlainArgs(
        dhcpId = dhcpId ?: throw PulumiNullFieldException("dhcpId"),
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
