@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDnsZonePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsZoneId NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetWorkloadNetworkDnsZonePlainArgs(
    public val dnsZoneId: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDnsZonePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDnsZonePlainArgs =
        com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDnsZonePlainArgs.builder()
            .dnsZoneId(dnsZoneId.let({ args0 -> args0 }))
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadNetworkDnsZonePlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadNetworkDnsZonePlainArgsBuilder internal constructor() {
    private var dnsZoneId: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
     */
    @JvmName("igmuevsxjrclhiyn")
    public suspend fun dnsZoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsZoneId = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("lbrkcelxyqiyttux")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mpulunedtwuqyxcc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWorkloadNetworkDnsZonePlainArgs = GetWorkloadNetworkDnsZonePlainArgs(
        dnsZoneId = dnsZoneId ?: throw PulumiNullFieldException("dnsZoneId"),
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
