@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkVMGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vmGroupId NSX VM Group identifier. Generally the same as the VM Group's display name
 */
public data class GetWorkloadNetworkVMGroupPlainArgs(
    public val privateCloudName: String,
    public val resourceGroupName: String,
    public val vmGroupId: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkVMGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkVMGroupPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkVMGroupPlainArgs.builder()
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmGroupId(vmGroupId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadNetworkVMGroupPlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadNetworkVMGroupPlainArgsBuilder internal constructor() {
    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    private var vmGroupId: String? = null

    /**
     * @param value Name of the private cloud
     */
    @JvmName("ykvdpdaehdkqfhkg")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fkgimupcoxrbjkwq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value NSX VM Group identifier. Generally the same as the VM Group's display name
     */
    @JvmName("bnqiaqmhdiagrmsb")
    public suspend fun vmGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmGroupId = mapped
    }

    internal fun build(): GetWorkloadNetworkVMGroupPlainArgs = GetWorkloadNetworkVMGroupPlainArgs(
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vmGroupId = vmGroupId ?: throw PulumiNullFieldException("vmGroupId"),
    )
}
