@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.IdentitySourceArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.SslEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * vCenter Single Sign On Identity Source
 * @property alias The domain's NetBIOS name
 * @property baseGroupDN The base distinguished name for groups
 * @property baseUserDN The base distinguished name for users
 * @property domain The domain's dns name
 * @property name The name of the identity source
 * @property password The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
 * @property primaryServer Primary server URL
 * @property secondaryServer Secondary server URL
 * @property ssl Protect LDAP communication using SSL certificate (LDAPS)
 * @property username The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
 */
public data class IdentitySourceArgs(
    public val alias: Output<String>? = null,
    public val baseGroupDN: Output<String>? = null,
    public val baseUserDN: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val name: Output<String>? = null,
    public val password: Output<String>? = null,
    public val primaryServer: Output<String>? = null,
    public val secondaryServer: Output<String>? = null,
    public val ssl: Output<Either<String, SslEnum>>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.IdentitySourceArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.IdentitySourceArgs =
        com.pulumi.azurenative.avs.inputs.IdentitySourceArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .baseGroupDN(baseGroupDN?.applyValue({ args0 -> args0 }))
            .baseUserDN(baseUserDN?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .primaryServer(primaryServer?.applyValue({ args0 -> args0 }))
            .secondaryServer(secondaryServer?.applyValue({ args0 -> args0 }))
            .ssl(
                ssl?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentitySourceArgs].
 */
@PulumiTagMarker
public class IdentitySourceArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var baseGroupDN: Output<String>? = null

    private var baseUserDN: Output<String>? = null

    private var domain: Output<String>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var primaryServer: Output<String>? = null

    private var secondaryServer: Output<String>? = null

    private var ssl: Output<Either<String, SslEnum>>? = null

    private var username: Output<String>? = null

    /**
     * @param value The domain's NetBIOS name
     */
    @JvmName("hcuaemcndjvowoof")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value The base distinguished name for groups
     */
    @JvmName("knepvgfulrdshfor")
    public suspend fun baseGroupDN(`value`: Output<String>) {
        this.baseGroupDN = value
    }

    /**
     * @param value The base distinguished name for users
     */
    @JvmName("qbgthpfnolooltve")
    public suspend fun baseUserDN(`value`: Output<String>) {
        this.baseUserDN = value
    }

    /**
     * @param value The domain's dns name
     */
    @JvmName("dcqefwmljjocxmte")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The name of the identity source
     */
    @JvmName("lustjghoedcqjcnv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
     */
    @JvmName("wsqffcjhfijpprhh")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Primary server URL
     */
    @JvmName("ikvfolvsqgqgdljy")
    public suspend fun primaryServer(`value`: Output<String>) {
        this.primaryServer = value
    }

    /**
     * @param value Secondary server URL
     */
    @JvmName("wmrhvcnbkridhyup")
    public suspend fun secondaryServer(`value`: Output<String>) {
        this.secondaryServer = value
    }

    /**
     * @param value Protect LDAP communication using SSL certificate (LDAPS)
     */
    @JvmName("gwmnmnwmtsphnvjm")
    public suspend fun ssl(`value`: Output<Either<String, SslEnum>>) {
        this.ssl = value
    }

    /**
     * @param value The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
     */
    @JvmName("ykjrcnsxjcjetmij")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The domain's NetBIOS name
     */
    @JvmName("korkcvjgqsfwnhtq")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value The base distinguished name for groups
     */
    @JvmName("pqowfgwrunudydom")
    public suspend fun baseGroupDN(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseGroupDN = mapped
    }

    /**
     * @param value The base distinguished name for users
     */
    @JvmName("jberdykjpvvyvgmx")
    public suspend fun baseUserDN(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseUserDN = mapped
    }

    /**
     * @param value The domain's dns name
     */
    @JvmName("kavkewdymdbxfuce")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The name of the identity source
     */
    @JvmName("yswbpcoruiilhoab")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
     */
    @JvmName("yalumrrtjeyicaam")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Primary server URL
     */
    @JvmName("cpdwfauvjrnaxatm")
    public suspend fun primaryServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryServer = mapped
    }

    /**
     * @param value Secondary server URL
     */
    @JvmName("qgfoysjxcfaqrrlu")
    public suspend fun secondaryServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryServer = mapped
    }

    /**
     * @param value Protect LDAP communication using SSL certificate (LDAPS)
     */
    @JvmName("wgfehcupjbhghqcq")
    public suspend fun ssl(`value`: Either<String, SslEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssl = mapped
    }

    /**
     * @param value Protect LDAP communication using SSL certificate (LDAPS)
     */
    @JvmName("wmtfkrnmowcrntjv")
    public fun ssl(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ssl = mapped
    }

    /**
     * @param value Protect LDAP communication using SSL certificate (LDAPS)
     */
    @JvmName("jchxvphvovqargwb")
    public fun ssl(`value`: SslEnum) {
        val toBeMapped = Either.ofRight<String, SslEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ssl = mapped
    }

    /**
     * @param value The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
     */
    @JvmName("levyxewihyltfxfk")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): IdentitySourceArgs = IdentitySourceArgs(
        alias = alias,
        baseGroupDN = baseGroupDN,
        baseUserDN = baseUserDN,
        domain = domain,
        name = name,
        password = password,
        primaryServer = primaryServer,
        secondaryServer = secondaryServer,
        ssl = ssl,
        username = username,
    )
}
