@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.PrivateCloudIdentityArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity for the virtual machine.
 * @property type The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
 */
public data class PrivateCloudIdentityArgs(
    public val type: Output<Either<String, ResourceIdentityType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.PrivateCloudIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.PrivateCloudIdentityArgs =
        com.pulumi.azurenative.avs.inputs.PrivateCloudIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateCloudIdentityArgs].
 */
@PulumiTagMarker
public class PrivateCloudIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ResourceIdentityType>>? = null

    /**
     * @param value The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
     */
    @JvmName("apcashfwqdriykum")
    public suspend fun type(`value`: Output<Either<String, ResourceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
     */
    @JvmName("adipemvixaiqpbiy")
    public suspend fun type(`value`: Either<String, ResourceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
     */
    @JvmName("pplgoaweurbxbhax")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
     */
    @JvmName("jchekvsdfawwjabr")
    public fun type(`value`: ResourceIdentityType) {
        val toBeMapped = Either.ofRight<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PrivateCloudIdentityArgs = PrivateCloudIdentityArgs(
        type = type,
    )
}
