@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Administrative credentials for accessing vCenter and NSX-T
 * @property nsxtPassword NSX-T Manager password
 * @property nsxtUsername NSX-T Manager username
 * @property vcenterPassword vCenter admin password
 * @property vcenterUsername vCenter admin username
 */
public data class ListPrivateCloudAdminCredentialsResult(
    public val nsxtPassword: String,
    public val nsxtUsername: String,
    public val vcenterPassword: String,
    public val vcenterUsername: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.ListPrivateCloudAdminCredentialsResult):
            ListPrivateCloudAdminCredentialsResult = ListPrivateCloudAdminCredentialsResult(
            nsxtPassword = javaType.nsxtPassword(),
            nsxtUsername = javaType.nsxtUsername(),
            vcenterPassword = javaType.vcenterPassword(),
            vcenterUsername = javaType.vcenterUsername(),
        )
    }
}
