@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VM-VM placement policy properties
 * @property affinityType placement policy affinity type
 * @property displayName Display name of the placement policy
 * @property provisioningState The provisioning state
 * @property state Whether the placement policy is enabled or disabled
 * @property type placement policy type
 * Expected value is 'VmVm'.
 * @property vmMembers Virtual machine members list
 */
public data class VmVmPlacementPolicyPropertiesResponse(
    public val affinityType: String,
    public val displayName: String? = null,
    public val provisioningState: String,
    public val state: String? = null,
    public val type: String,
    public val vmMembers: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.VmVmPlacementPolicyPropertiesResponse):
            VmVmPlacementPolicyPropertiesResponse = VmVmPlacementPolicyPropertiesResponse(
            affinityType = javaType.affinityType(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            vmMembers = javaType.vmMembers().map({ args0 -> args0 }),
        )
    }
}
