@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin

import com.pulumi.azurenative.azureactivedirectory.CIAMTenantArgs.builder
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.CIAMResourceSKUArgs
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.CIAMResourceSKUArgsBuilder
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.CreateCIAMTenantPropertiesArgs
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.CreateCIAMTenantPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Azure AD for customers resource.
 * Azure REST API version: 2023-05-17-preview.
 * ## Example Usage
 * ### Create_CIAM_tenant
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ciamTenant = new AzureNative.AzureActiveDirectory.CIAMTenant("ciamTenant", new()
 *     {
 *         CreateTenantProperties = new AzureNative.AzureActiveDirectory.Inputs.CreateCIAMTenantPropertiesArgs
 *         {
 *             CountryCode = "US",
 *             DisplayName = "Contoso",
 *         },
 *         Location = "United States",
 *         ResourceGroupName = "contosoResourceGroup",
 *         ResourceName = "contoso",
 *         Sku = new AzureNative.AzureActiveDirectory.Inputs.CIAMResourceSKUArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azureactivedirectory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azureactivedirectory.NewCIAMTenant(ctx, "ciamTenant", &azureactivedirectory.CIAMTenantArgs{
 * 			CreateTenantProperties: &azureactivedirectory.CreateCIAMTenantPropertiesArgs{
 * 				CountryCode: pulumi.String("US"),
 * 				DisplayName: pulumi.String("Contoso"),
 * 			},
 * 			Location:          pulumi.String("United States"),
 * 			ResourceGroupName: pulumi.String("contosoResourceGroup"),
 * 			ResourceName:      pulumi.String("contoso"),
 * 			Sku: &azureactivedirectory.CIAMResourceSKUArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azureactivedirectory.CIAMTenant;
 * import com.pulumi.azurenative.azureactivedirectory.CIAMTenantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ciamTenant = new CIAMTenant("ciamTenant", CIAMTenantArgs.builder()
 *             .createTenantProperties(Map.ofEntries(
 *                 Map.entry("countryCode", "US"),
 *                 Map.entry("displayName", "Contoso")
 *             ))
 *             .location("United States")
 *             .resourceGroupName("contosoResourceGroup")
 *             .resourceName("contoso")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azureactivedirectory:CIAMTenant contoso /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureActiveDirectory/ciamDirectories/{resourceName}
 * ```
 * @property createTenantProperties These properties are used to create the Azure AD for customers tenant. These properties are not part of the Azure resource.
 * @property location The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/ciam-data-location) for more information.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The initial sub domain of the tenant.
 * @property sku SKU properties of the Azure AD for customers tenant. Learn more about Azure AD for customers billing at [https://aka&#46;ms/ciambilling](https://aka.ms/ciambilling).
 * @property tags Resource Tags
 * @property tenantId An identifier of the Azure AD for customers tenant.
 */
public data class CIAMTenantArgs(
    public val createTenantProperties: Output<CreateCIAMTenantPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<CIAMResourceSKUArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azureactivedirectory.CIAMTenantArgs> {
    override fun toJava(): com.pulumi.azurenative.azureactivedirectory.CIAMTenantArgs =
        com.pulumi.azurenative.azureactivedirectory.CIAMTenantArgs.builder()
            .createTenantProperties(
                createTenantProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CIAMTenantArgs].
 */
@PulumiTagMarker
public class CIAMTenantArgsBuilder internal constructor() {
    private var createTenantProperties: Output<CreateCIAMTenantPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<CIAMResourceSKUArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value These properties are used to create the Azure AD for customers tenant. These properties are not part of the Azure resource.
     */
    @JvmName("hodqqmwjilxjswky")
    public suspend fun createTenantProperties(`value`: Output<CreateCIAMTenantPropertiesArgs>) {
        this.createTenantProperties = value
    }

    /**
     * @param value The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/ciam-data-location) for more information.
     */
    @JvmName("itllahhqrjddyoql")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ulkprjjcovmcfcom")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The initial sub domain of the tenant.
     */
    @JvmName("klksxvcumncepvii")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value SKU properties of the Azure AD for customers tenant. Learn more about Azure AD for customers billing at [https://aka&#46;ms/ciambilling](https://aka.ms/ciambilling).
     */
    @JvmName("ywemeloxkxyxurrl")
    public suspend fun sku(`value`: Output<CIAMResourceSKUArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource Tags
     */
    @JvmName("agonwtlidmoxvnlf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An identifier of the Azure AD for customers tenant.
     */
    @JvmName("tuujvnbtqoissgtw")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value These properties are used to create the Azure AD for customers tenant. These properties are not part of the Azure resource.
     */
    @JvmName("ptmqlgtbubbirkpw")
    public suspend fun createTenantProperties(`value`: CreateCIAMTenantPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createTenantProperties = mapped
    }

    /**
     * @param argument These properties are used to create the Azure AD for customers tenant. These properties are not part of the Azure resource.
     */
    @JvmName("csnryfhpnddnduip")
    public suspend
    fun createTenantProperties(argument: suspend CreateCIAMTenantPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CreateCIAMTenantPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.createTenantProperties = mapped
    }

    /**
     * @param value The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/ciam-data-location) for more information.
     */
    @JvmName("lpvxlfrtruanrawi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fjbhpcchayculuoh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The initial sub domain of the tenant.
     */
    @JvmName("quctvjrflwicgvpw")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value SKU properties of the Azure AD for customers tenant. Learn more about Azure AD for customers billing at [https://aka&#46;ms/ciambilling](https://aka.ms/ciambilling).
     */
    @JvmName("eqrerwhexxdgnjsa")
    public suspend fun sku(`value`: CIAMResourceSKUArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU properties of the Azure AD for customers tenant. Learn more about Azure AD for customers billing at [https://aka&#46;ms/ciambilling](https://aka.ms/ciambilling).
     */
    @JvmName("rkahtjgmgohvnjay")
    public suspend fun sku(argument: suspend CIAMResourceSKUArgsBuilder.() -> Unit) {
        val toBeMapped = CIAMResourceSKUArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource Tags
     */
    @JvmName("dvtugxspvyniaxfv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource Tags
     */
    @JvmName("tcvqipdpwrwfgrmw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value An identifier of the Azure AD for customers tenant.
     */
    @JvmName("fdchvylkxqjveanp")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): CIAMTenantArgs = CIAMTenantArgs(
        createTenantProperties = createTenantProperties,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sku = sku,
        tags = tags,
        tenantId = tenantId,
    )
}
