@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The Azure AD for customers resource.
 * @property billingType The type of billing. Will be MAU for all new customers. Cannot be changed if value is 'MAU'. Learn more about Azure AD for customers billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cbilling).
 * @property createTenantProperties These properties are used to create the Azure AD for customers tenant. These properties are not part of the Azure resource.
 * @property domainName The domain name of the tenant
 * @property effectiveStartDateUtc The data from which the billing type took effect
 * @property id An identifier that represents the Azure AD for customers tenant resource.
 * @property location The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/ciam-data-location) for more information.
 * @property name The name of the Azure AD for customers tenant resource.
 * @property provisioningState
 * @property sku SKU properties of the Azure AD for customers tenant. Learn more about Azure AD for customers billing at [https://aka&#46;ms/ciambilling](https://aka.ms/ciambilling).
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource Tags
 * @property tenantId An identifier of the Azure AD for customers tenant.
 * @property type The type of the Azure AD for customers tenant resource.
 */
public data class GetCIAMTenantResult(
    public val billingType: String,
    public val createTenantProperties: CreateCIAMTenantPropertiesResponse,
    public val domainName: String,
    public val effectiveStartDateUtc: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sku: CIAMResourceSKUResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azureactivedirectory.outputs.GetCIAMTenantResult):
            GetCIAMTenantResult = GetCIAMTenantResult(
            billingType = javaType.billingType(),
            createTenantProperties = javaType.createTenantProperties().let({ args0 ->
                com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.CreateCIAMTenantPropertiesResponse.Companion.toKotlin(args0)
            }),
            domainName = javaType.domainName(),
            effectiveStartDateUtc = javaType.effectiveStartDateUtc(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.CIAMResourceSKUResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
