@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getActiveDirectoryConnectorPlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getDataControllerPlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getFailoverGroupPlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getPostgresInstancePlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getSqlManagedInstancePlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getSqlServerDatabasePlain
import com.pulumi.azurenative.azurearcdata.AzurearcdataFunctions.getSqlServerInstancePlain
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetActiveDirectoryConnectorPlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetActiveDirectoryConnectorPlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetDataControllerPlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetDataControllerPlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetFailoverGroupPlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetFailoverGroupPlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetPostgresInstancePlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetPostgresInstancePlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlManagedInstancePlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlManagedInstancePlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerDatabasePlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerDatabasePlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerInstancePlainArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.GetSqlServerInstancePlainArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetActiveDirectoryConnectorResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetDataControllerResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetFailoverGroupResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetPostgresInstanceResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlManagedInstanceResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerDatabaseResult
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerInstanceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetActiveDirectoryConnectorResult.Companion.toKotlin as getActiveDirectoryConnectorResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetDataControllerResult.Companion.toKotlin as getDataControllerResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetFailoverGroupResult.Companion.toKotlin as getFailoverGroupResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetPostgresInstanceResult.Companion.toKotlin as getPostgresInstanceResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlManagedInstanceResult.Companion.toKotlin as getSqlManagedInstanceResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerDatabaseResult.Companion.toKotlin as getSqlServerDatabaseResultToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.GetSqlServerInstanceResult.Companion.toKotlin as getSqlServerInstanceResultToKotlin

public object AzurearcdataFunctions {
    /**
     * Retrieves an Active Directory connector resource
     * Azure REST API version: 2023-01-15-preview.
     * @param argument null
     * @return Active directory connector resource
     */
    public suspend fun getActiveDirectoryConnector(argument: GetActiveDirectoryConnectorPlainArgs):
        GetActiveDirectoryConnectorResult =
        getActiveDirectoryConnectorResultToKotlin(getActiveDirectoryConnectorPlain(argument.toJava()).await())

    /**
     * @see [getActiveDirectoryConnector].
     * @param activeDirectoryConnectorName The name of the Active Directory connector instance
     * @param dataControllerName The name of the data controller
     * @param resourceGroupName The name of the Azure resource group
     * @return Active directory connector resource
     */
    public suspend fun getActiveDirectoryConnector(
        activeDirectoryConnectorName: String,
        dataControllerName: String,
        resourceGroupName: String,
    ): GetActiveDirectoryConnectorResult {
        val argument = GetActiveDirectoryConnectorPlainArgs(
            activeDirectoryConnectorName = activeDirectoryConnectorName,
            dataControllerName = dataControllerName,
            resourceGroupName = resourceGroupName,
        )
        return getActiveDirectoryConnectorResultToKotlin(getActiveDirectoryConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getActiveDirectoryConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetActiveDirectoryConnectorPlainArgs].
     * @return Active directory connector resource
     */
    public suspend
    fun getActiveDirectoryConnector(argument: suspend GetActiveDirectoryConnectorPlainArgsBuilder.() -> Unit):
        GetActiveDirectoryConnectorResult {
        val builder = GetActiveDirectoryConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActiveDirectoryConnectorResultToKotlin(getActiveDirectoryConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a dataController resource
     * Azure REST API version: 2023-01-15-preview.
     * @param argument null
     * @return Data controller resource
     */
    public suspend fun getDataController(argument: GetDataControllerPlainArgs):
        GetDataControllerResult =
        getDataControllerResultToKotlin(getDataControllerPlain(argument.toJava()).await())

    /**
     * @see [getDataController].
     * @param dataControllerName The name of the data controller
     * @param resourceGroupName The name of the Azure resource group
     * @return Data controller resource
     */
    public suspend fun getDataController(dataControllerName: String, resourceGroupName: String):
        GetDataControllerResult {
        val argument = GetDataControllerPlainArgs(
            dataControllerName = dataControllerName,
            resourceGroupName = resourceGroupName,
        )
        return getDataControllerResultToKotlin(getDataControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetDataControllerPlainArgs].
     * @return Data controller resource
     */
    public suspend
    fun getDataController(argument: suspend GetDataControllerPlainArgsBuilder.() -> Unit):
        GetDataControllerResult {
        val builder = GetDataControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataControllerResultToKotlin(getDataControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a failover group resource
     * Azure REST API version: 2023-01-15-preview.
     * @param argument null
     * @return A failover group resource.
     */
    public suspend fun getFailoverGroup(argument: GetFailoverGroupPlainArgs): GetFailoverGroupResult =
        getFailoverGroupResultToKotlin(getFailoverGroupPlain(argument.toJava()).await())

    /**
     * @see [getFailoverGroup].
     * @param failoverGroupName The name of the Failover Group
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlManagedInstanceName Name of SQL Managed Instance
     * @return A failover group resource.
     */
    public suspend fun getFailoverGroup(
        failoverGroupName: String,
        resourceGroupName: String,
        sqlManagedInstanceName: String,
    ): GetFailoverGroupResult {
        val argument = GetFailoverGroupPlainArgs(
            failoverGroupName = failoverGroupName,
            resourceGroupName = resourceGroupName,
            sqlManagedInstanceName = sqlManagedInstanceName,
        )
        return getFailoverGroupResultToKotlin(getFailoverGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getFailoverGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetFailoverGroupPlainArgs].
     * @return A failover group resource.
     */
    public suspend
    fun getFailoverGroup(argument: suspend GetFailoverGroupPlainArgsBuilder.() -> Unit):
        GetFailoverGroupResult {
        val builder = GetFailoverGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFailoverGroupResultToKotlin(getFailoverGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a postgres Instance resource
     * Azure REST API version: 2023-01-15-preview.
     * @param argument null
     * @return A Postgres Instance.
     */
    public suspend fun getPostgresInstance(argument: GetPostgresInstancePlainArgs):
        GetPostgresInstanceResult =
        getPostgresInstanceResultToKotlin(getPostgresInstancePlain(argument.toJava()).await())

    /**
     * @see [getPostgresInstance].
     * @param postgresInstanceName Name of Postgres Instance
     * @param resourceGroupName The name of the Azure resource group
     * @return A Postgres Instance.
     */
    public suspend fun getPostgresInstance(postgresInstanceName: String, resourceGroupName: String):
        GetPostgresInstanceResult {
        val argument = GetPostgresInstancePlainArgs(
            postgresInstanceName = postgresInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getPostgresInstanceResultToKotlin(getPostgresInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getPostgresInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetPostgresInstancePlainArgs].
     * @return A Postgres Instance.
     */
    public suspend
    fun getPostgresInstance(argument: suspend GetPostgresInstancePlainArgsBuilder.() -> Unit):
        GetPostgresInstanceResult {
        val builder = GetPostgresInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPostgresInstanceResultToKotlin(getPostgresInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a SQL Managed Instance resource
     * Azure REST API version: 2023-01-15-preview.
     * @param argument null
     * @return A SqlManagedInstance.
     */
    public suspend fun getSqlManagedInstance(argument: GetSqlManagedInstancePlainArgs):
        GetSqlManagedInstanceResult =
        getSqlManagedInstanceResultToKotlin(getSqlManagedInstancePlain(argument.toJava()).await())

    /**
     * @see [getSqlManagedInstance].
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlManagedInstanceName Name of SQL Managed Instance
     * @return A SqlManagedInstance.
     */
    public suspend fun getSqlManagedInstance(
        resourceGroupName: String,
        sqlManagedInstanceName: String,
    ): GetSqlManagedInstanceResult {
        val argument = GetSqlManagedInstancePlainArgs(
            resourceGroupName = resourceGroupName,
            sqlManagedInstanceName = sqlManagedInstanceName,
        )
        return getSqlManagedInstanceResultToKotlin(getSqlManagedInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlManagedInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetSqlManagedInstancePlainArgs].
     * @return A SqlManagedInstance.
     */
    public suspend
    fun getSqlManagedInstance(argument: suspend GetSqlManagedInstancePlainArgsBuilder.() -> Unit):
        GetSqlManagedInstanceResult {
        val builder = GetSqlManagedInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlManagedInstanceResultToKotlin(getSqlManagedInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves an Arc Sql Server database.
     * Azure REST API version: 2023-01-15-preview.
     * @param argument null
     * @return Arc Sql Server database
     */
    public suspend fun getSqlServerDatabase(argument: GetSqlServerDatabasePlainArgs):
        GetSqlServerDatabaseResult =
        getSqlServerDatabaseResultToKotlin(getSqlServerDatabasePlain(argument.toJava()).await())

    /**
     * @see [getSqlServerDatabase].
     * @param databaseName Name of the database
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlServerInstanceName Name of SQL Server Instance
     * @return Arc Sql Server database
     */
    public suspend fun getSqlServerDatabase(
        databaseName: String,
        resourceGroupName: String,
        sqlServerInstanceName: String,
    ): GetSqlServerDatabaseResult {
        val argument = GetSqlServerDatabasePlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            sqlServerInstanceName = sqlServerInstanceName,
        )
        return getSqlServerDatabaseResultToKotlin(getSqlServerDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlServerDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetSqlServerDatabasePlainArgs].
     * @return Arc Sql Server database
     */
    public suspend
    fun getSqlServerDatabase(argument: suspend GetSqlServerDatabasePlainArgsBuilder.() -> Unit):
        GetSqlServerDatabaseResult {
        val builder = GetSqlServerDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlServerDatabaseResultToKotlin(getSqlServerDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves a SQL Server Instance resource
     * Azure REST API version: 2023-01-15-preview.
     * @param argument null
     * @return A SqlServerInstance.
     */
    public suspend fun getSqlServerInstance(argument: GetSqlServerInstancePlainArgs):
        GetSqlServerInstanceResult =
        getSqlServerInstanceResultToKotlin(getSqlServerInstancePlain(argument.toJava()).await())

    /**
     * @see [getSqlServerInstance].
     * @param resourceGroupName The name of the Azure resource group
     * @param sqlServerInstanceName Name of SQL Server Instance
     * @return A SqlServerInstance.
     */
    public suspend fun getSqlServerInstance(resourceGroupName: String, sqlServerInstanceName: String):
        GetSqlServerInstanceResult {
        val argument = GetSqlServerInstancePlainArgs(
            resourceGroupName = resourceGroupName,
            sqlServerInstanceName = sqlServerInstanceName,
        )
        return getSqlServerInstanceResultToKotlin(getSqlServerInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlServerInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurearcdata&#46;kotlin&#46;inputs&#46;GetSqlServerInstancePlainArgs].
     * @return A SqlServerInstance.
     */
    public suspend
    fun getSqlServerInstance(argument: suspend GetSqlServerInstancePlainArgsBuilder.() -> Unit):
        GetSqlServerInstanceResult {
        val builder = GetSqlServerInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlServerInstanceResultToKotlin(getSqlServerInstancePlain(builtArgument.toJava()).await())
    }
}
