@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.SqlServerDatabaseArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlServerDatabaseResourcePropertiesArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlServerDatabaseResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Arc Sql Server database
 * Azure REST API version: 2023-01-15-preview.
 * ## Example Usage
 * ### Create a Arc Sql Server database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlServerDatabase = new AzureNative.AzureArcData.SqlServerDatabase("sqlServerDatabase", new()
 *     {
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         Properties = new AzureNative.AzureArcData.Inputs.SqlServerDatabaseResourcePropertiesArgs
 *         {
 *             BackupInformation = new AzureNative.AzureArcData.Inputs.SqlServerDatabaseResourcePropertiesBackupInformationArgs
 *             {
 *                 LastFullBackup = "2022-05-05T16:26:33.883Z",
 *                 LastLogBackup = "2022-05-10T16:26:33.883Z",
 *             },
 *             CollationName = "SQL_Latin1_General_CP1_CI_AS",
 *             CompatibilityLevel = 150,
 *             DatabaseCreationDate = "2022-04-05T16:26:33.883Z",
 *             DatabaseOptions = new AzureNative.AzureArcData.Inputs.SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs
 *             {
 *                 IsAutoCloseOn = true,
 *                 IsAutoCreateStatsOn = true,
 *                 IsAutoShrinkOn = true,
 *                 IsAutoUpdateStatsOn = true,
 *                 IsEncrypted = true,
 *                 IsMemoryOptimizationEnabled = true,
 *                 IsRemoteDataArchiveEnabled = true,
 *                 IsTrustworthyOn = true,
 *             },
 *             IsReadOnly = true,
 *             RecoveryMode = "Full",
 *             SizeMB = 150,
 *             SpaceAvailableMB = 100,
 *             State = "Online",
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlServerInstanceName = "testSqlServerInstance",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewSqlServerDatabase(ctx, "sqlServerDatabase", &azurearcdata.SqlServerDatabaseArgs{
 * 			DatabaseName: pulumi.String("testdb"),
 * 			Location:     pulumi.String("southeastasia"),
 * 			Properties: azurearcdata.SqlServerDatabaseResourcePropertiesResponse{
 * 				BackupInformation: &azurearcdata.SqlServerDatabaseResourcePropertiesBackupInformationArgs{
 * 					LastFullBackup: pulumi.String("2022-05-05T16:26:33.883Z"),
 * 					LastLogBackup:  pulumi.String("2022-05-10T16:26:33.883Z"),
 * 				},
 * 				CollationName:        pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 				CompatibilityLevel:   pulumi.Int(150),
 * 				DatabaseCreationDate: pulumi.String("2022-04-05T16:26:33.883Z"),
 * 				DatabaseOptions: &azurearcdata.SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs{
 * 					IsAutoCloseOn:               pulumi.Bool(true),
 * 					IsAutoCreateStatsOn:         pulumi.Bool(true),
 * 					IsAutoShrinkOn:              pulumi.Bool(true),
 * 					IsAutoUpdateStatsOn:         pulumi.Bool(true),
 * 					IsEncrypted:                 pulumi.Bool(true),
 * 					IsMemoryOptimizationEnabled: pulumi.Bool(true),
 * 					IsRemoteDataArchiveEnabled:  pulumi.Bool(true),
 * 					IsTrustworthyOn:             pulumi.Bool(true),
 * 				},
 * 				IsReadOnly:       pulumi.Bool(true),
 * 				RecoveryMode:     pulumi.String("Full"),
 * 				SizeMB:           pulumi.Float64(150),
 * 				SpaceAvailableMB: pulumi.Float64(100),
 * 				State:            pulumi.String("Online"),
 * 			},
 * 			ResourceGroupName:     pulumi.String("testrg"),
 * 			SqlServerInstanceName: pulumi.String("testSqlServerInstance"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.SqlServerDatabase;
 * import com.pulumi.azurenative.azurearcdata.SqlServerDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlServerDatabase = new SqlServerDatabase("sqlServerDatabase", SqlServerDatabaseArgs.builder()
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backupInformation", Map.ofEntries(
 *                     Map.entry("lastFullBackup", "2022-05-05T16:26:33.883Z"),
 *                     Map.entry("lastLogBackup", "2022-05-10T16:26:33.883Z")
 *                 )),
 *                 Map.entry("collationName", "SQL_Latin1_General_CP1_CI_AS"),
 *                 Map.entry("compatibilityLevel", 150),
 *                 Map.entry("databaseCreationDate", "2022-04-05T16:26:33.883Z"),
 *                 Map.entry("databaseOptions", Map.ofEntries(
 *                     Map.entry("isAutoCloseOn", true),
 *                     Map.entry("isAutoCreateStatsOn", true),
 *                     Map.entry("isAutoShrinkOn", true),
 *                     Map.entry("isAutoUpdateStatsOn", true),
 *                     Map.entry("isEncrypted", true),
 *                     Map.entry("isMemoryOptimizationEnabled", true),
 *                     Map.entry("isRemoteDataArchiveEnabled", true),
 *                     Map.entry("isTrustworthyOn", true)
 *                 )),
 *                 Map.entry("isReadOnly", true),
 *                 Map.entry("recoveryMode", "Full"),
 *                 Map.entry("sizeMB", 150),
 *                 Map.entry("spaceAvailableMB", 100),
 *                 Map.entry("state", "Online")
 *             ))
 *             .resourceGroupName("testrg")
 *             .sqlServerInstanceName("testSqlServerInstance")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:SqlServerDatabase testdb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/sqlServerInstances/{sqlServerInstanceName}/databases/{databaseName}
 * ```
 * @property databaseName Name of the database
 * @property location The geo-location where the resource lives
 * @property properties Properties of Arc Sql Server database
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlServerInstanceName Name of SQL Server Instance
 * @property tags Resource tags.
 */
public data class SqlServerDatabaseArgs(
    public val databaseName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<SqlServerDatabaseResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlServerInstanceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.SqlServerDatabaseArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.SqlServerDatabaseArgs =
        com.pulumi.azurenative.azurearcdata.SqlServerDatabaseArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlServerInstanceName(sqlServerInstanceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SqlServerDatabaseArgs].
 */
@PulumiTagMarker
public class SqlServerDatabaseArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<SqlServerDatabaseResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlServerInstanceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the database
     */
    @JvmName("orpfplxoutcspxng")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jxrfhmsmoyvrbjeq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of Arc Sql Server database
     */
    @JvmName("ywciwerkxupbnrrr")
    public suspend fun properties(`value`: Output<SqlServerDatabaseResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("qsfgpxxoegvaqckx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("ascwvuwqyqghuauy")
    public suspend fun sqlServerInstanceName(`value`: Output<String>) {
        this.sqlServerInstanceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fcrdxiaajkmruwxl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the database
     */
    @JvmName("fhbpthgkusnryceo")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jvjftagqfnnalltf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of Arc Sql Server database
     */
    @JvmName("dtrwojilvnrbenyu")
    public suspend fun properties(`value`: SqlServerDatabaseResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Arc Sql Server database
     */
    @JvmName("fkoniwxxdufivimb")
    public suspend
    fun properties(argument: suspend SqlServerDatabaseResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SqlServerDatabaseResourcePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("likewcbjoioegbxp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("xuqosaokyuffopno")
    public suspend fun sqlServerInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerInstanceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sswvrxnhwhlcscuk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("sakwvxkhrgxeqqms")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SqlServerDatabaseArgs = SqlServerDatabaseArgs(
        databaseName = databaseName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sqlServerInstanceName = sqlServerInstanceName,
        tags = tags,
    )
}
