@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.SqlServerInstanceArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlServerInstancePropertiesArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlServerInstancePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A SqlServerInstance.
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * ## Example Usage
 * ### Updates a SQL Server Instance tags.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlServerInstance = new AzureNative.AzureArcData.SqlServerInstance("sqlServerInstance", new()
 *     {
 *         Location = "northeurope",
 *         Properties = new AzureNative.AzureArcData.Inputs.SqlServerInstancePropertiesArgs
 *         {
 *             AzureDefenderStatus = "Protected",
 *             AzureDefenderStatusLastUpdated = "2020-01-02T17:18:19.1234567Z",
 *             Collation = "collation",
 *             ContainerResourceId = "Resource id of hosting Arc Machine",
 *             Cores = "4",
 *             CurrentVersion = "2012",
 *             Edition = "Developer",
 *             HostType = "Physical Server",
 *             InstanceName = "name of instance",
 *             LicenseType = "Free",
 *             PatchLevel = "patchlevel",
 *             ProductId = "sql id",
 *             Status = "Registered",
 *             TcpDynamicPorts = "1433",
 *             TcpStaticPorts = "1433",
 *             VCore = "4",
 *             Version = "SQL Server 2012",
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlServerInstanceName = "testsqlServerInstance",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewSqlServerInstance(ctx, "sqlServerInstance", &azurearcdata.SqlServerInstanceArgs{
 * 			Location: pulumi.String("northeurope"),
 * 			Properties: &azurearcdata.SqlServerInstancePropertiesArgs{
 * 				AzureDefenderStatus:            pulumi.String("Protected"),
 * 				AzureDefenderStatusLastUpdated: pulumi.String("2020-01-02T17:18:19.1234567Z"),
 * 				Collation:                      pulumi.String("collation"),
 * 				ContainerResourceId:            pulumi.String("Resource id of hosting Arc Machine"),
 * 				Cores:                          pulumi.String("4"),
 * 				CurrentVersion:                 pulumi.String("2012"),
 * 				Edition:                        pulumi.String("Developer"),
 * 				HostType:                       pulumi.String("Physical Server"),
 * 				InstanceName:                   pulumi.String("name of instance"),
 * 				LicenseType:                    pulumi.String("Free"),
 * 				PatchLevel:                     pulumi.String("patchlevel"),
 * 				ProductId:                      pulumi.String("sql id"),
 * 				Status:                         pulumi.String("Registered"),
 * 				TcpDynamicPorts:                pulumi.String("1433"),
 * 				TcpStaticPorts:                 pulumi.String("1433"),
 * 				VCore:                          pulumi.String("4"),
 * 				Version:                        pulumi.String("SQL Server 2012"),
 * 			},
 * 			ResourceGroupName:     pulumi.String("testrg"),
 * 			SqlServerInstanceName: pulumi.String("testsqlServerInstance"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.SqlServerInstance;
 * import com.pulumi.azurenative.azurearcdata.SqlServerInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlServerInstance = new SqlServerInstance("sqlServerInstance", SqlServerInstanceArgs.builder()
 *             .location("northeurope")
 *             .properties(Map.ofEntries(
 *                 Map.entry("azureDefenderStatus", "Protected"),
 *                 Map.entry("azureDefenderStatusLastUpdated", "2020-01-02T17:18:19.1234567Z"),
 *                 Map.entry("collation", "collation"),
 *                 Map.entry("containerResourceId", "Resource id of hosting Arc Machine"),
 *                 Map.entry("cores", "4"),
 *                 Map.entry("currentVersion", "2012"),
 *                 Map.entry("edition", "Developer"),
 *                 Map.entry("hostType", "Physical Server"),
 *                 Map.entry("instanceName", "name of instance"),
 *                 Map.entry("licenseType", "Free"),
 *                 Map.entry("patchLevel", "patchlevel"),
 *                 Map.entry("productId", "sql id"),
 *                 Map.entry("status", "Registered"),
 *                 Map.entry("tcpDynamicPorts", "1433"),
 *                 Map.entry("tcpStaticPorts", "1433"),
 *                 Map.entry("vCore", "4"),
 *                 Map.entry("version", "SQL Server 2012")
 *             ))
 *             .resourceGroupName("testrg")
 *             .sqlServerInstanceName("testsqlServerInstance")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:SqlServerInstance testsqlServerInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/sqlServerInstances/{sqlServerInstanceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property properties null
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlServerInstanceName Name of SQL Server Instance
 * @property tags Resource tags.
 */
public data class SqlServerInstanceArgs(
    public val location: Output<String>? = null,
    public val properties: Output<SqlServerInstancePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlServerInstanceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.SqlServerInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.SqlServerInstanceArgs =
        com.pulumi.azurenative.azurearcdata.SqlServerInstanceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlServerInstanceName(sqlServerInstanceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SqlServerInstanceArgs].
 */
@PulumiTagMarker
public class SqlServerInstanceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<SqlServerInstancePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlServerInstanceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dmvxwewwoxslaoqq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value null
     */
    @JvmName("sawkbringokoapry")
    public suspend fun properties(`value`: Output<SqlServerInstancePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("udjsibpymivpfrak")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("wrnmeafdmkqjdwhd")
    public suspend fun sqlServerInstanceName(`value`: Output<String>) {
        this.sqlServerInstanceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nlidxmrbwnhsvfit")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("srlijtkejfkeknyc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value null
     */
    @JvmName("dxvpeecpxqjlivbk")
    public suspend fun properties(`value`: SqlServerInstancePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("lcgxxuupqdinjrgt")
    public suspend
    fun properties(argument: suspend SqlServerInstancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SqlServerInstancePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("vhthjtaodoctsmkb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("gmrbpsmmxaeiitco")
    public suspend fun sqlServerInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerInstanceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pirewhijfajmvtmm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("eaykvpitwkghdywp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SqlServerInstanceArgs = SqlServerInstanceArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sqlServerInstanceName = sqlServerInstanceName,
        tags = tags,
    )
}
