@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.BasicLoginInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Username and password for basic login authentication.
 * @property password Login password.
 * @property username Login username.
 */
public data class BasicLoginInformationArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.BasicLoginInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.BasicLoginInformationArgs =
        com.pulumi.azurenative.azurearcdata.inputs.BasicLoginInformationArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BasicLoginInformationArgs].
 */
@PulumiTagMarker
public class BasicLoginInformationArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Login password.
     */
    @JvmName("aqmxworjmdscutsm")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Login username.
     */
    @JvmName("mjeqidablyakfdkq")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Login password.
     */
    @JvmName("wcdvonirohasxuyk")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Login username.
     */
    @JvmName("tnsynuieautvtmxk")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): BasicLoginInformationArgs = BasicLoginInformationArgs(
        password = password,
        username = username,
    )
}
