@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of a failover group resource.
 * @property partnerManagedInstanceId The resource ID of the partner SQL managed instance.
 * @property spec The specifications of the failover group resource.
 * @property status The status of the failover group custom resource.
 */
public data class FailoverGroupPropertiesArgs(
    public val partnerManagedInstanceId: Output<String>,
    public val spec: Output<FailoverGroupSpecArgs>,
    public val status: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupPropertiesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupPropertiesArgs.builder()
            .partnerManagedInstanceId(partnerManagedInstanceId.applyValue({ args0 -> args0 }))
            .spec(spec.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FailoverGroupPropertiesArgs].
 */
@PulumiTagMarker
public class FailoverGroupPropertiesArgsBuilder internal constructor() {
    private var partnerManagedInstanceId: Output<String>? = null

    private var spec: Output<FailoverGroupSpecArgs>? = null

    private var status: Output<Any>? = null

    /**
     * @param value The resource ID of the partner SQL managed instance.
     */
    @JvmName("msctgngsexihnxtv")
    public suspend fun partnerManagedInstanceId(`value`: Output<String>) {
        this.partnerManagedInstanceId = value
    }

    /**
     * @param value The specifications of the failover group resource.
     */
    @JvmName("lneouvvetbkxamre")
    public suspend fun spec(`value`: Output<FailoverGroupSpecArgs>) {
        this.spec = value
    }

    /**
     * @param value The status of the failover group custom resource.
     */
    @JvmName("octdcsuddwknesha")
    public suspend fun status(`value`: Output<Any>) {
        this.status = value
    }

    /**
     * @param value The resource ID of the partner SQL managed instance.
     */
    @JvmName("qhxaecgmrqvajjmb")
    public suspend fun partnerManagedInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerManagedInstanceId = mapped
    }

    /**
     * @param value The specifications of the failover group resource.
     */
    @JvmName("veeadopnggjewgnw")
    public suspend fun spec(`value`: FailoverGroupSpecArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument The specifications of the failover group resource.
     */
    @JvmName("oiierisvupntuekw")
    public suspend fun spec(argument: suspend FailoverGroupSpecArgsBuilder.() -> Unit) {
        val toBeMapped = FailoverGroupSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    /**
     * @param value The status of the failover group custom resource.
     */
    @JvmName("lvlnpmqvrjsqotwk")
    public suspend fun status(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): FailoverGroupPropertiesArgs = FailoverGroupPropertiesArgs(
        partnerManagedInstanceId = partnerManagedInstanceId ?: throw
            PulumiNullFieldException("partnerManagedInstanceId"),
        spec = spec ?: throw PulumiNullFieldException("spec"),
        status = status,
    )
}
