@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.GetSqlManagedInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlManagedInstanceName Name of SQL Managed Instance
 */
public data class GetSqlManagedInstancePlainArgs(
    public val resourceGroupName: String,
    public val sqlManagedInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.GetSqlManagedInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.GetSqlManagedInstancePlainArgs =
        com.pulumi.azurenative.azurearcdata.inputs.GetSqlManagedInstancePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlManagedInstanceName(sqlManagedInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlManagedInstancePlainArgs].
 */
@PulumiTagMarker
public class GetSqlManagedInstancePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlManagedInstanceName: String? = null

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("ntodxcswjksttfdl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Managed Instance
     */
    @JvmName("qjuhwrcutqrlloic")
    public suspend fun sqlManagedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlManagedInstanceName = mapped
    }

    internal fun build(): GetSqlManagedInstancePlainArgs = GetSqlManagedInstancePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlManagedInstanceName = sqlManagedInstanceName ?: throw
            PulumiNullFieldException("sqlManagedInstanceName"),
    )
}
