@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.K8sSecurityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The kubernetes security information.
 * @property activeDirectory The kubernetes active directory information.
 * @property adminLoginSecret Admin login secret key
 * @property serviceCertificateSecret Service certificate secret used
 * @property transparentDataEncryption Transparent data encryption information.
 */
public data class K8sSecurityArgs(
    public val activeDirectory: Output<K8sActiveDirectoryArgs>? = null,
    public val adminLoginSecret: Output<String>? = null,
    public val serviceCertificateSecret: Output<String>? = null,
    public val transparentDataEncryption: Output<K8stransparentDataEncryptionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.K8sSecurityArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.K8sSecurityArgs =
        com.pulumi.azurenative.azurearcdata.inputs.K8sSecurityArgs.builder()
            .activeDirectory(activeDirectory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .adminLoginSecret(adminLoginSecret?.applyValue({ args0 -> args0 }))
            .serviceCertificateSecret(serviceCertificateSecret?.applyValue({ args0 -> args0 }))
            .transparentDataEncryption(
                transparentDataEncryption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [K8sSecurityArgs].
 */
@PulumiTagMarker
public class K8sSecurityArgsBuilder internal constructor() {
    private var activeDirectory: Output<K8sActiveDirectoryArgs>? = null

    private var adminLoginSecret: Output<String>? = null

    private var serviceCertificateSecret: Output<String>? = null

    private var transparentDataEncryption: Output<K8stransparentDataEncryptionArgs>? = null

    /**
     * @param value The kubernetes active directory information.
     */
    @JvmName("mlogqxpejsjhedla")
    public suspend fun activeDirectory(`value`: Output<K8sActiveDirectoryArgs>) {
        this.activeDirectory = value
    }

    /**
     * @param value Admin login secret key
     */
    @JvmName("emdgqduwajtvotrs")
    public suspend fun adminLoginSecret(`value`: Output<String>) {
        this.adminLoginSecret = value
    }

    /**
     * @param value Service certificate secret used
     */
    @JvmName("njhnqlituxhqcvfe")
    public suspend fun serviceCertificateSecret(`value`: Output<String>) {
        this.serviceCertificateSecret = value
    }

    /**
     * @param value Transparent data encryption information.
     */
    @JvmName("bkjrblsxdkmtnhuh")
    public suspend fun transparentDataEncryption(`value`: Output<K8stransparentDataEncryptionArgs>) {
        this.transparentDataEncryption = value
    }

    /**
     * @param value The kubernetes active directory information.
     */
    @JvmName("lvogtbysshobhenn")
    public suspend fun activeDirectory(`value`: K8sActiveDirectoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectory = mapped
    }

    /**
     * @param argument The kubernetes active directory information.
     */
    @JvmName("bdysmbkkpqyfgvkf")
    public suspend fun activeDirectory(argument: suspend K8sActiveDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = K8sActiveDirectoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.activeDirectory = mapped
    }

    /**
     * @param value Admin login secret key
     */
    @JvmName("ugosghfourxlsqgd")
    public suspend fun adminLoginSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminLoginSecret = mapped
    }

    /**
     * @param value Service certificate secret used
     */
    @JvmName("ftgoxpbqavkfbrrf")
    public suspend fun serviceCertificateSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCertificateSecret = mapped
    }

    /**
     * @param value Transparent data encryption information.
     */
    @JvmName("hxfqibakqhwniysi")
    public suspend fun transparentDataEncryption(`value`: K8stransparentDataEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transparentDataEncryption = mapped
    }

    /**
     * @param argument Transparent data encryption information.
     */
    @JvmName("tftuvrsknthvqluu")
    public suspend
    fun transparentDataEncryption(argument: suspend K8stransparentDataEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = K8stransparentDataEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.transparentDataEncryption = mapped
    }

    internal fun build(): K8sSecurityArgs = K8sSecurityArgs(
        activeDirectory = activeDirectory,
        adminLoginSecret = adminLoginSecret,
        serviceCertificateSecret = serviceCertificateSecret,
        transparentDataEncryption = transparentDataEncryption,
    )
}
