@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.PostgresInstancePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Postgres Instance properties.
 * @property admin The instance admin
 * @property basicLoginInformation Username and password for basic authentication.
 * @property dataControllerId The data controller id
 * @property k8sRaw The raw kubernetes information
 * @property lastUploadedDate Last uploaded date from Kubernetes cluster. Defaults to current date time
 */
public data class PostgresInstancePropertiesArgs(
    public val admin: Output<String>? = null,
    public val basicLoginInformation: Output<BasicLoginInformationArgs>? = null,
    public val dataControllerId: Output<String>? = null,
    public val k8sRaw: Output<Any>? = null,
    public val lastUploadedDate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.PostgresInstancePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.PostgresInstancePropertiesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.PostgresInstancePropertiesArgs.builder()
            .admin(admin?.applyValue({ args0 -> args0 }))
            .basicLoginInformation(
                basicLoginInformation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataControllerId(dataControllerId?.applyValue({ args0 -> args0 }))
            .k8sRaw(k8sRaw?.applyValue({ args0 -> args0 }))
            .lastUploadedDate(lastUploadedDate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PostgresInstancePropertiesArgs].
 */
@PulumiTagMarker
public class PostgresInstancePropertiesArgsBuilder internal constructor() {
    private var admin: Output<String>? = null

    private var basicLoginInformation: Output<BasicLoginInformationArgs>? = null

    private var dataControllerId: Output<String>? = null

    private var k8sRaw: Output<Any>? = null

    private var lastUploadedDate: Output<String>? = null

    /**
     * @param value The instance admin
     */
    @JvmName("uhhtqsdcelbhjarh")
    public suspend fun admin(`value`: Output<String>) {
        this.admin = value
    }

    /**
     * @param value Username and password for basic authentication.
     */
    @JvmName("wbujakeamvepvsev")
    public suspend fun basicLoginInformation(`value`: Output<BasicLoginInformationArgs>) {
        this.basicLoginInformation = value
    }

    /**
     * @param value The data controller id
     */
    @JvmName("jqnojnidsfondoow")
    public suspend fun dataControllerId(`value`: Output<String>) {
        this.dataControllerId = value
    }

    /**
     * @param value The raw kubernetes information
     */
    @JvmName("srcdximdrhldvwlc")
    public suspend fun k8sRaw(`value`: Output<Any>) {
        this.k8sRaw = value
    }

    /**
     * @param value Last uploaded date from Kubernetes cluster. Defaults to current date time
     */
    @JvmName("tqttbfvmthucljre")
    public suspend fun lastUploadedDate(`value`: Output<String>) {
        this.lastUploadedDate = value
    }

    /**
     * @param value The instance admin
     */
    @JvmName("hgeicosnuqhwchat")
    public suspend fun admin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.admin = mapped
    }

    /**
     * @param value Username and password for basic authentication.
     */
    @JvmName("rturyxalsghyqqpy")
    public suspend fun basicLoginInformation(`value`: BasicLoginInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicLoginInformation = mapped
    }

    /**
     * @param argument Username and password for basic authentication.
     */
    @JvmName("ulegekadkaftsuhv")
    public suspend
    fun basicLoginInformation(argument: suspend BasicLoginInformationArgsBuilder.() -> Unit) {
        val toBeMapped = BasicLoginInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.basicLoginInformation = mapped
    }

    /**
     * @param value The data controller id
     */
    @JvmName("cewvbyqkadlkgyhl")
    public suspend fun dataControllerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataControllerId = mapped
    }

    /**
     * @param value The raw kubernetes information
     */
    @JvmName("cdpwptuqlgxplaie")
    public suspend fun k8sRaw(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.k8sRaw = mapped
    }

    /**
     * @param value Last uploaded date from Kubernetes cluster. Defaults to current date time
     */
    @JvmName("hxiupcdosdseqdbc")
    public suspend fun lastUploadedDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUploadedDate = mapped
    }

    internal fun build(): PostgresInstancePropertiesArgs = PostgresInstancePropertiesArgs(
        admin = admin,
        basicLoginInformation = basicLoginInformation,
        dataControllerId = dataControllerId,
        k8sRaw = k8sRaw,
        lastUploadedDate = lastUploadedDate,
    )
}
