@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.DatabaseState
import com.pulumi.azurenative.azurearcdata.kotlin.enums.RecoveryMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of Arc Sql Server database resource
 * @property backupInformation
 * @property collationName Collation of the database.
 * @property compatibilityLevel Compatibility level of the database
 * @property databaseCreationDate Creation date of the database.
 * @property databaseOptions List of features that are enabled for the database
 * @property isReadOnly Whether the database is read only or not.
 * @property recoveryMode Status of the database.
 * @property sizeMB Size of the database.
 * @property spaceAvailableMB Space left of the database.
 * @property state State of the database.
 */
public data class SqlServerDatabaseResourcePropertiesArgs(
    public val backupInformation: Output<SqlServerDatabaseResourcePropertiesBackupInformationArgs>? =
        null,
    public val collationName: Output<String>? = null,
    public val compatibilityLevel: Output<Int>? = null,
    public val databaseCreationDate: Output<String>? = null,
    public val databaseOptions: Output<SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs>? =
        null,
    public val isReadOnly: Output<Boolean>? = null,
    public val recoveryMode: Output<Either<String, RecoveryMode>>? = null,
    public val sizeMB: Output<Double>? = null,
    public val spaceAvailableMB: Output<Double>? = null,
    public val state: Output<Either<String, DatabaseState>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesArgs.builder()
            .backupInformation(backupInformation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .collationName(collationName?.applyValue({ args0 -> args0 }))
            .compatibilityLevel(compatibilityLevel?.applyValue({ args0 -> args0 }))
            .databaseCreationDate(databaseCreationDate?.applyValue({ args0 -> args0 }))
            .databaseOptions(databaseOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isReadOnly(isReadOnly?.applyValue({ args0 -> args0 }))
            .recoveryMode(
                recoveryMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sizeMB(sizeMB?.applyValue({ args0 -> args0 }))
            .spaceAvailableMB(spaceAvailableMB?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlServerDatabaseResourcePropertiesArgs].
 */
@PulumiTagMarker
public class SqlServerDatabaseResourcePropertiesArgsBuilder internal constructor() {
    private var backupInformation: Output<SqlServerDatabaseResourcePropertiesBackupInformationArgs>? =
        null

    private var collationName: Output<String>? = null

    private var compatibilityLevel: Output<Int>? = null

    private var databaseCreationDate: Output<String>? = null

    private var databaseOptions: Output<SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs>? =
        null

    private var isReadOnly: Output<Boolean>? = null

    private var recoveryMode: Output<Either<String, RecoveryMode>>? = null

    private var sizeMB: Output<Double>? = null

    private var spaceAvailableMB: Output<Double>? = null

    private var state: Output<Either<String, DatabaseState>>? = null

    /**
     * @param value
     */
    @JvmName("ddggrevtoewmnfxr")
    public suspend
    fun backupInformation(`value`: Output<SqlServerDatabaseResourcePropertiesBackupInformationArgs>) {
        this.backupInformation = value
    }

    /**
     * @param value Collation of the database.
     */
    @JvmName("ecjmvpviexhmsjqi")
    public suspend fun collationName(`value`: Output<String>) {
        this.collationName = value
    }

    /**
     * @param value Compatibility level of the database
     */
    @JvmName("vrwbiangstadncdi")
    public suspend fun compatibilityLevel(`value`: Output<Int>) {
        this.compatibilityLevel = value
    }

    /**
     * @param value Creation date of the database.
     */
    @JvmName("louhadlcstbbktwe")
    public suspend fun databaseCreationDate(`value`: Output<String>) {
        this.databaseCreationDate = value
    }

    /**
     * @param value List of features that are enabled for the database
     */
    @JvmName("forcfxbusppadqla")
    public suspend
    fun databaseOptions(`value`: Output<SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs>) {
        this.databaseOptions = value
    }

    /**
     * @param value Whether the database is read only or not.
     */
    @JvmName("mioobdjyfvikqjje")
    public suspend fun isReadOnly(`value`: Output<Boolean>) {
        this.isReadOnly = value
    }

    /**
     * @param value Status of the database.
     */
    @JvmName("ukxxbscfrtysxjch")
    public suspend fun recoveryMode(`value`: Output<Either<String, RecoveryMode>>) {
        this.recoveryMode = value
    }

    /**
     * @param value Size of the database.
     */
    @JvmName("owkpvxaenyqilpmh")
    public suspend fun sizeMB(`value`: Output<Double>) {
        this.sizeMB = value
    }

    /**
     * @param value Space left of the database.
     */
    @JvmName("gitmombkyjqvasxa")
    public suspend fun spaceAvailableMB(`value`: Output<Double>) {
        this.spaceAvailableMB = value
    }

    /**
     * @param value State of the database.
     */
    @JvmName("haejqspusymhevfa")
    public suspend fun state(`value`: Output<Either<String, DatabaseState>>) {
        this.state = value
    }

    /**
     * @param value
     */
    @JvmName("jlbhyncfgiywrvbx")
    public suspend
    fun backupInformation(`value`: SqlServerDatabaseResourcePropertiesBackupInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupInformation = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aimfpowljsnrddgu")
    public suspend
    fun backupInformation(argument: suspend SqlServerDatabaseResourcePropertiesBackupInformationArgsBuilder.() -> Unit) {
        val toBeMapped = SqlServerDatabaseResourcePropertiesBackupInformationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.backupInformation = mapped
    }

    /**
     * @param value Collation of the database.
     */
    @JvmName("falbgixsdfqsfylu")
    public suspend fun collationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collationName = mapped
    }

    /**
     * @param value Compatibility level of the database
     */
    @JvmName("qwrwvubghvadvhdq")
    public suspend fun compatibilityLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compatibilityLevel = mapped
    }

    /**
     * @param value Creation date of the database.
     */
    @JvmName("cfnlmjsitynfeukh")
    public suspend fun databaseCreationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseCreationDate = mapped
    }

    /**
     * @param value List of features that are enabled for the database
     */
    @JvmName("wqgsymlrtxhwqsev")
    public suspend
    fun databaseOptions(`value`: SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseOptions = mapped
    }

    /**
     * @param argument List of features that are enabled for the database
     */
    @JvmName("chmcikfkdlbpypuo")
    public suspend
    fun databaseOptions(argument: suspend SqlServerDatabaseResourcePropertiesDatabaseOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlServerDatabaseResourcePropertiesDatabaseOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.databaseOptions = mapped
    }

    /**
     * @param value Whether the database is read only or not.
     */
    @JvmName("gcvmmxhrquxerlhm")
    public suspend fun isReadOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isReadOnly = mapped
    }

    /**
     * @param value Status of the database.
     */
    @JvmName("ddfrfrwipehviobt")
    public suspend fun recoveryMode(`value`: Either<String, RecoveryMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryMode = mapped
    }

    /**
     * @param value Status of the database.
     */
    @JvmName("dljlmjgxudvyomta")
    public fun recoveryMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecoveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryMode = mapped
    }

    /**
     * @param value Status of the database.
     */
    @JvmName("oaudujwiauyfsbhs")
    public fun recoveryMode(`value`: RecoveryMode) {
        val toBeMapped = Either.ofRight<String, RecoveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryMode = mapped
    }

    /**
     * @param value Size of the database.
     */
    @JvmName("lghgkccrlychjrfk")
    public suspend fun sizeMB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeMB = mapped
    }

    /**
     * @param value Space left of the database.
     */
    @JvmName("uphuputtctcssqxv")
    public suspend fun spaceAvailableMB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceAvailableMB = mapped
    }

    /**
     * @param value State of the database.
     */
    @JvmName("fqkqqinvirlnmwox")
    public suspend fun state(`value`: Either<String, DatabaseState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the database.
     */
    @JvmName("edvpduktariitlxg")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabaseState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the database.
     */
    @JvmName("phguwfessqopdgml")
    public fun state(`value`: DatabaseState) {
        val toBeMapped = Either.ofRight<String, DatabaseState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): SqlServerDatabaseResourcePropertiesArgs =
        SqlServerDatabaseResourcePropertiesArgs(
            backupInformation = backupInformation,
            collationName = collationName,
            compatibilityLevel = compatibilityLevel,
            databaseCreationDate = databaseCreationDate,
            databaseOptions = databaseOptions,
            isReadOnly = isReadOnly,
            recoveryMode = recoveryMode,
            sizeMB = sizeMB,
            spaceAvailableMB = spaceAvailableMB,
            state = state,
        )
}
