@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The kubernetes network settings information.
 * @property forceencryption If 1, then SQL Server forces all connections to be encrypted. By default, this option is 0
 * @property tlsciphers Specifies which ciphers are allowed by SQL Server for TLS
 * @property tlsprotocols A comma-separated list of which TLS protocols are allowed by SQL Server
 */
public data class K8sNetworkSettingsResponse(
    public val forceencryption: Int? = null,
    public val tlsciphers: String? = null,
    public val tlsprotocols: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.K8sNetworkSettingsResponse):
            K8sNetworkSettingsResponse = K8sNetworkSettingsResponse(
            forceencryption = javaType.forceencryption().map({ args0 -> args0 }).orElse(null),
            tlsciphers = javaType.tlsciphers().map({ args0 -> args0 }).orElse(null),
            tlsprotocols = javaType.tlsprotocols().map({ args0 -> args0 }).orElse(null),
        )
    }
}
