@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredata.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A SQL server registration.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property propertyBag Optional Properties as JSON string
 * @property resourceGroup Resource Group Name
 * @property subscriptionId Subscription Id
 * @property systemData Read only system data
 * @property tags Resource tags.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetSqlServerRegistrationResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val propertyBag: String? = null,
    public val resourceGroup: String? = null,
    public val subscriptionId: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azuredata.outputs.GetSqlServerRegistrationResult):
            GetSqlServerRegistrationResult = GetSqlServerRegistrationResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            propertyBag = javaType.propertyBag().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azuredata.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
