@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredata.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A SQL server.
 * @property cores Cores of the Sql Server.
 * @property edition Sql Server Edition.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property propertyBag Sql Server Json Property Bag.
 * @property registrationID ID for Parent Sql Server Registration.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 * @property version Version of the Sql Server.
 */
public data class GetSqlServerResult(
    public val cores: Int? = null,
    public val edition: String? = null,
    public val id: String,
    public val name: String,
    public val propertyBag: String? = null,
    public val registrationID: String? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredata.outputs.GetSqlServerResult):
            GetSqlServerResult = GetSqlServerResult(
            cores = javaType.cores().map({ args0 -> args0 }).orElse(null),
            edition = javaType.edition().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            propertyBag = javaType.propertyBag().map({ args0 -> args0 }).orElse(null),
            registrationID = javaType.registrationID().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
