@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Transfer Storage Blobs or Tables
 */
public enum class DataType(
    public val javaValue: com.pulumi.azurenative.azuredatatransfer.enums.DataType,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.enums.DataType> {
    Blob(com.pulumi.azurenative.azuredatatransfer.enums.DataType.Blob),
    Table(com.pulumi.azurenative.azuredatatransfer.enums.DataType.Table),
    ;

    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.enums.DataType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.enums.DataType): DataType =
            DataType.values().first { it.javaValue == javaType }
    }
}
