@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.GetFlowPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name for the connection that is to be requested.
 * @property flowName The name for the flow that is to be onboarded.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetFlowPlainArgs(
    public val connectionName: String,
    public val flowName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.GetFlowPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.inputs.GetFlowPlainArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.GetFlowPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .flowName(flowName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFlowPlainArgs].
 */
@PulumiTagMarker
public class GetFlowPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var flowName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name for the connection that is to be requested.
     */
    @JvmName("uijaxyrmgpdioapo")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The name for the flow that is to be onboarded.
     */
    @JvmName("uumndpllnulehwbd")
    public suspend fun flowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.flowName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yisunoilvdlmdgfx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFlowPlainArgs = GetFlowPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        flowName = flowName ?: throw PulumiNullFieldException("flowName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
